% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tprDiameterCpp.r
\name{tprDiameterCpp}
\alias{tprDiameterCpp}
\alias{tprDiameterCpp,tprTrees-method}
\title{Function to extract diameters from Taper curve using Rcpp}
\usage{
tprDiameterCpp(obj, Hx, bark = TRUE, cp = TRUE, mono = TRUE, Rfn = NULL)

\S4method{tprDiameterCpp}{tprTrees}(obj, Hx, bark = TRUE, cp = TRUE, mono = TRUE, Rfn = NULL)
}
\arguments{
\item{obj}{object of class 'tprTrees'}

\item{Hx}{vector of heights for which diameter are required}

\item{bark}{should diameter over or under bark be returned?}

\item{cp}{cartesian product, i.e. apply all \code{Hx} to all trees, defaults
to TRUE}

\item{mono}{logical to decide whether a supporting diameter should be added
in case the taper curve is regarded as non-monotonic. Defaults to TRUE.}

\item{Rfn}{setting for residuals error matrix, defaults to \code{"sig2"}, see
details.}
}
\value{
a vector, in case only one diameter (i.e. Hx) is required per tree
(\code{cp=FALSE}) or a matrix of size
\code{length(trees)} x \code{length(Hx)} (\code{cp=TRUE}).
}
\description{
This function uses Rcpp and C-code to implement the diameter
estimation of package TapeR to allow for faster estimation if no interval
information is required.
}
\details{
Function evaluates taper curves at required height \code{Hx}. By
default (\code{cp==TRUE}), the taper curve is evaluated at \code{Hx} for each
tree. If \code{cp==FALSE}, each tree is evaluated at exactly one Hx (recycled
if necessary). This feature is intended for situations where diameter in
relative heights are required. Then, the recycling of one height Hx (e.g.
1.3m) is not possible, since relative heights depend on absolute tree height,
which might be different for each tree. Hence a call like
\code{tprDiameter(obj, Hx=0.3*Ht(obj), cp=FALSE)} is necessary.
}
\section{Methods (by class)}{
\itemize{
\item \code{tprDiameterCpp(tprTrees)}: method for class 'tprTrees'

}}
\examples{
obj <- tprTrees(spp=c(1 , 3),
                Hm=list(c(1.3, 5), c(1.3, 5)),
                Dm=list(c(27, 25), c(27, 25)),
                Ht=c(27, 27))
Hx <- seq(0, 1, 0.1)
tprDiameterCpp(obj, Hx = Hx)
tprDiameterCpp(obj, Hx = Hx, bark=FALSE)
tprDiameterCpp(obj, Hx = c(1, 2), bark=FALSE, cp=FALSE)

\donttest{
require(rbenchmark)
benchmark(tprDiameter(obj, Hx, bark = TRUE),
          tprDiameterCpp(obj, Hx, bark = TRUE),
          replications = 10000)[,1:4]
}
}
\seealso{
\code{\link{tprDiameter}} if confidence or prediction intervals
are required.
}
