% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hx_root.f.R
\name{Hx_root.f}
\alias{Hx_root.f}
\title{find root (height) given diameter, measurements and fitted model}
\usage{
Hx_root.f(Hx, Dx, Hm, Dm, mHt, sHt, par.lme, Rfn, ...)
}
\arguments{
\item{Hx}{Numeric vector of stem heights (m) along which to return the 
expected diameter}

\item{Dx}{expected diameter}

\item{Hm}{Numeric vector of stem heights (m) along which diameter measurements 
were taken for calibration. Can be of length 1. Must be of same length as \code{Dm}}

\item{Dm}{Numeric vector of diameter measurements (cm) taken for calibration.
Can be of length 1. Must be of same length as \code{Hm}}

\item{mHt}{Scalar. Tree height (m)}

\item{sHt}{Scalar. Standard deviation of stem height. Can be 0 if height was 
measured without error}

\item{par.lme}{List of taper model parameters obtained by 
\code{\link{TapeR_FIT_LME.f}}.}

\item{Rfn}{list with function name to provide estimated or assumed residual 
variances for the given measurements, optionally parameters for such functions}

\item{...}{not currently used}
}
\value{
deviation between observed diameter \code{Dx} and diameter in height
\code{Hx}.
}
\description{
Internal function not usually called by users
}
\details{
function is called by \code{\link[stats]{uniroot}} inside 
\code{\link{E_HDx_HmDm_HT.f}}
}
\author{
Edgar Kublin
}
