% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_functions.R
\name{plot_error}
\alias{plot_error}
\title{Plot the Models Error Rates on the Testing Partitions}
\usage{
plot_error(model.obj, error = "MAPE", palette = "Set1")
}
\arguments{
\item{model.obj}{A train_model object}

\item{error}{A character, defines the type of error metrics to plot, possible metric - "MAPE" or "RMSE"}

\item{palette}{A character, defines the color type to used on the plot, use row.names(RColorBrewer::brewer.pal.info) to view possible color palletes}
}
\value{
A plot with a summery of the models error rate by testing partition
}
\description{
Plot the Models Error Rates on the Testing Partitions
}
\details{
The plot_model provides a visualization of the models performance on the testing paritions for the train_model function output
}
\examples{
 \dontrun{
# Defining the models and their arguments
methods <- list(ets1 = list(method = "ets",
                            method_arg = list(opt.crit = "lik"),
                            notes = "ETS model with opt.crit = lik"),
                ets2 = list(method = "ets",
                            method_arg = list(opt.crit = "amse"),
                            notes = "ETS model with opt.crit = amse"),
                arima1 = list(method = "arima",
                              method_arg = list(order = c(2,1,0)),
                              notes = "ARIMA(2,1,0)"),
                arima2 = list(method = "arima",
                              method_arg = list(order = c(2,1,2),
                                                seasonal = list(order = c(1,1,1))),
                              notes = "SARIMA(2,1,2)(1,1,1)"),
                hw = list(method = "HoltWinters",
                          method_arg = NULL,
                          notes = "HoltWinters Model"),
                tslm = list(method = "tslm",
                            method_arg = list(formula = input ~ trend + season),
                            notes = "tslm model with trend and seasonal components"))
# Training the models with backtesting
md <- train_model(input = USgas,
                  methods = methods,
                  train_method = list(partitions = 6, 
                                      sample.out = 12, 
                                      space = 3),
                  horizon = 12,
                  error = "MAPE")
                  
# Plot the models performance on the testing partitions
plot_error(model.obj = md)
}
}
