% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCT.r
\name{pct}
\alias{pct}
\alias{pct.rev}
\title{Percentage Change Transformation}
\usage{
pct(x)

pct.rev(p, xi, addinit = TRUE)
}
\arguments{
\item{x}{A numeric vector or univariate time series of class \code{ts}.}

\item{p}{A numeric vector or univariate time series of percentage changes.
Possibly returned by \code{pct()}.}

\item{xi}{Initial value/observation of \code{x} (\code{x[1]}). First known
non-transformed value used to recursively obtain the original series.}

\item{addinit}{If \code{TRUE}, \code{xi} is included in the return.}
}
\value{
A vector of length \code{length(x)-1} containing the transformed
values.
}
\description{
The \code{pct()} function returns a transformation of the provided time
series using a Percentage Change transformation. \code{pct.rev()} reverses
the transformation.
}
\details{
The Percentage Change transformation is given approximately by
\deqn{ log(x[2:n] / x[1:(n-1)] ) = log( x[2:n] ) - log( x[1:(n-1)] ) } where
\code{n=length(x)}.
}
\examples{

data(NN5.A)
ts <- na.omit(NN5.A[,10])
length(ts)

p <- pct(ts)
length(p)

p_rev <- pct.rev(p, attributes(p)$xi)

all(round(p_rev,4)==round(ts,4))

}
\references{
R.H. Shumway and D.S. Stoffer, 2010, Time Series Analysis and
Its Applications: With R Examples. 3rd ed. 2011 edition ed. New York,
Springer.
}
\seealso{
Other transformation methods: 
\code{\link{Diff}()},
\code{\link{LogT}()},
\code{\link{WaveletT}()},
\code{\link{emd}()},
\code{\link{mas}()},
\code{\link{mlm_io}()},
\code{\link{outliers_bp}()},
\code{\link{train_test_subset}()}
}
\author{
Rebecca Pontes Salles
}
\concept{transformation methods}
\keyword{change}
\keyword{percentage}
\keyword{series}
\keyword{time}
\keyword{transform}
