% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSLSTM.R
\name{ts.lstm}
\alias{ts.lstm}
\title{Long Short Term Memory (LSTM) Model for Time Series Forecasting}
\usage{
ts.lstm(
  ts,
  xreg = NULL,
  tsLag,
  xregLag = 0,
  LSTMUnits,
  DenseUnits = NULL,
  DropoutRate = 0,
  Epochs = 10,
  CompLoss = "mse",
  CompMetrics = "mae",
  Optimizer = optimizer_rmsprop,
  ScaleOutput = c(NULL, "scale", "minmax"),
  ScaleInput = c(NULL, "scale", "minmax"),
  BatchSize = 1,
  LSTMActivationFn = "tanh",
  LSTMRecurrentActivationFn = "sigmoid",
  DenseActivationFn = "relu",
  ValidationSplit = 0.1,
  verbose = 2,
  RandomState = NULL,
  EarlyStopping = EarlyStopping(monitor = "val_loss", min_delta = 0, patience = 3,
    verbose = 0, mode = "auto"),
  ...
)
}
\arguments{
\item{ts}{Time series data}

\item{xreg}{Exogenous variables}

\item{tsLag}{Lag of time series data}

\item{xregLag}{Lag of exogenous variables}

\item{LSTMUnits}{Number of unit in LSTM layers}

\item{DenseUnits}{Number of unit in Extra Dense layers. A Dense layer with a single neuron is always added at the end.}

\item{DropoutRate}{Dropout rate}

\item{Epochs}{Number of epochs}

\item{CompLoss}{Loss function}

\item{CompMetrics}{Metrics}

\item{Optimizer}{'keras' optimizer}

\item{ScaleOutput}{Flag to indicate if ts shall be scaled before training}

\item{ScaleInput}{Flag to indicate if xreg shall be scaled before training}

\item{BatchSize}{Batch size to use during training}

\item{LSTMActivationFn}{Activation function for LSTM layers}

\item{LSTMRecurrentActivationFn}{Recurrent activation function for LSTM layers}

\item{DenseActivationFn}{Activation function for Extra Dense layers}

\item{ValidationSplit}{Validation split ration}

\item{verbose}{Indicate how much information is given during training. Accepted values, 0, 1 or 2.}

\item{RandomState}{seed for replication}

\item{EarlyStopping}{EarlyStopping according to 'keras'}

\item{...}{Extra arguments passed to keras::layer_lstm}
}
\value{
LSTMmodel object
}
\description{
The LSTM (Long Short-Term Memory) model is a Recurrent Neural Network (RNN) based architecture that is widely used for time series forecasting. Min-Max transformation has been used for data preparation. Here, we have used one LSTM layer as a simple LSTM model and a Dense layer is used as the output layer. Then, compile the model using the loss function, optimizer and metrics. This package is based on 'keras' and TensorFlow modules.
}
\examples{
\donttest{
  if (keras::is_keras_available()){
      y<-rnorm(100,mean=100,sd=50)
      x1<-rnorm(100,mean=50,sd=50)
      x2<-rnorm(100, mean=50, sd=25)
      x<-cbind(x1,x2)
      TSLSTM<-ts.lstm(ts=y,
                      xreg = x,
                      tsLag=2,
                      xregLag = 0,
                      LSTMUnits=5,
                      ScaleInput = 'scale',
                      ScaleOutput = 'scale',
                      Epochs=2)
  }
}
}
\references{
Paul, R.K. and Garai, S. (2021). Performance comparison of wavelets-based machine learning technique for forecasting agricultural commodity prices, Soft Computing, 25(20), 12857-12873
}
