% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_log_TOST.R
\name{boot_log_TOST}
\alias{boot_log_TOST}
\alias{boot_log_TOST.default}
\alias{boot_log_TOST.formula}
\title{Bootstrapped TOST with log transformed t-tests}
\usage{
boot_log_TOST(x, ...)

\method{boot_log_TOST}{default}(
  x,
  y = NULL,
  hypothesis = c("EQU", "MET"),
  paired = FALSE,
  var.equal = FALSE,
  eqb = 1.25,
  alpha = 0.05,
  null = 1,
  boot_ci = c("stud", "basic", "perc"),
  R = 1999,
  ...
)

\method{boot_log_TOST}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{hypothesis}{'EQU' for equivalence (default), or 'MET' for minimal effects test, the alternative hypothesis.}

\item{paired}{a logical indicating whether you want a paired t-test.}

\item{var.equal}{a logical variable indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{eqb}{Equivalence bound. Can provide 1 value (negative value is taken as the lower bound) or 2 specific values that represent the upper and lower equivalence bounds.}

\item{alpha}{alpha level (default = 0.05)}

\item{null}{Null hypothesis value for a two-tailed test (default is 1).}

\item{boot_ci}{type of bootstrap confidence interval. Options include studentized (stud), empirical/basic (basic) and percentile (perc) confidence intervals.}

\item{R}{number of bootstrap replicates}

\item{formula}{a formula of the form lhs ~ rhs where lhs is a numeric variable giving the data values and rhs either 1 for a one-sample or paired test or a factor with two levels giving the corresponding groups. If lhs is of class "Pair" and rhs is 1, a paired test is done.}

\item{data}{an optional matrix or data frame (or similar: see model.frame) containing the variables in the formula formula. By default the variables are taken from environment(formula).}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. Defaults to getOption("na.action").}
}
\value{
An S3 object of class
\code{"TOSTt"} is returned containing the following slots:
\itemize{
\item "TOST": A table of class \code{"data.frame"} containing two-tailed t-test and both one-tailed results.
\item "eqb": A table of class \code{"data.frame"} containing equivalence bound settings.
\item "effsize":  table of class \code{"data.frame"} containing effect size estimates.
\item "hypothesis": String stating the hypothesis being tested.
\item "smd": List containing the results of the means ratio calculation.
\itemize{
\item Items include: d (means ratio estimate), dlow (lower CI bound), dhigh (upper CI bound), d_df (degrees of freedom for SMD), d_sigma (SE), d_lambda (non-centrality), J (bias correction), smd_label (type of SMD), d_denom (denominator calculation)
}
\item "alpha": Alpha level set for the analysis.
\item "method": Type of t-test.
\item "decision": List included text regarding the decisions for statistical inference.
\item "boot": List containing the bootstrap samples.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A function for a bootstrap method for TOST with all types of t-tests.
}
\details{
The implemented test(s) corresponds to the proposal of Chapter 16 of Efron and Tibshirani (1994),
and recommended by He et al (2022).
Returns TOSTt class object with bootstrapped based results.
This is approximately equivalent to the percentile bootstrap method mentioned by He et al (2014).

For two-sample tests, the test is of \eqn{\bar log(x) - \bar log(y)} (mean of x minus mean of y).
For paired samples, the test is of the difference scores (z),
wherein \eqn{z =  log(x) - log(y) = log(x)/log(y)}, and the test is of \eqn{\bar z} (mean of the difference/ratio scores).

For details on the calculations in this function see \code{vignette("robustTOST")}.
}
\references{
Efron, B., & Tibshirani, R. J. (1994). An introduction to the bootstrap. CRC press

He, Y., Deng, Y., You, C., & Zhou, X. H. (2022). Equivalence tests for ratio of means in bioequivalence studies under crossover design. Statistical Methods in Medical Research, 09622802221093721.

Food and Drug Administration (2014). Bioavailability and Bioequivalence Studies Submitted in NDAs or INDs — General Considerations.
Center for Drug Evaluation and Research. Docket: FDA-2014-D-0204.
https://www.fda.gov/regulatory-information/search-fda-guidance-documents/bioavailability-and-bioequivalence-studies-submitted-ndas-or-inds-general-considerations
}
\seealso{
Other Robust tests: 
\code{\link{boot_t_TOST}()},
\code{\link{boot_t_test}()},
\code{\link{brunner_munzel}()},
\code{\link{log_TOST}()},
\code{\link{wilcox_TOST}()}

Other TOST: 
\code{\link{boot_t_TOST}()},
\code{\link{simple_htest}()},
\code{\link{t_TOST}()},
\code{\link{tsum_TOST}()},
\code{\link{wilcox_TOST}()}
}
\concept{Robust tests}
\concept{TOST}
