
# This file is automatically generated, you probably don't want to edit this

dataTOSTpairedOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "dataTOSTpairedOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            pairs = NULL,
            low_eqbound = -0.5,
            high_eqbound = 0.5,
            eqbound_type = "d",
            alpha = 0.05,
            desc = FALSE,
            plots = FALSE,
            low_eqbound_dz = -999999999,
            high_eqbound_dz = -999999999, ...) {

            super$initialize(
                package='TOSTER',
                name='dataTOSTpaired',
                requiresData=TRUE,
                ...)

            private$..pairs <- jmvcore::OptionPairs$new(
                "pairs",
                pairs,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..low_eqbound <- jmvcore::OptionNumber$new(
                "low_eqbound",
                low_eqbound,
                default=-0.5)
            private$..high_eqbound <- jmvcore::OptionNumber$new(
                "high_eqbound",
                high_eqbound,
                default=0.5)
            private$..eqbound_type <- jmvcore::OptionList$new(
                "eqbound_type",
                eqbound_type,
                options=list(
                    "d",
                    "raw"),
                default="d")
            private$..alpha <- jmvcore::OptionNumber$new(
                "alpha",
                alpha,
                min=0,
                max=1,
                default=0.05)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)
            private$..low_eqbound_dz <- jmvcore::OptionNumber$new(
                "low_eqbound_dz",
                low_eqbound_dz,
                default=-999999999,
                hidden=TRUE)
            private$..high_eqbound_dz <- jmvcore::OptionNumber$new(
                "high_eqbound_dz",
                high_eqbound_dz,
                default=-999999999,
                hidden=TRUE)

            self$.addOption(private$..pairs)
            self$.addOption(private$..low_eqbound)
            self$.addOption(private$..high_eqbound)
            self$.addOption(private$..eqbound_type)
            self$.addOption(private$..alpha)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
            self$.addOption(private$..low_eqbound_dz)
            self$.addOption(private$..high_eqbound_dz)
        }),
    active = list(
        pairs = function() private$..pairs$value,
        low_eqbound = function() private$..low_eqbound$value,
        high_eqbound = function() private$..high_eqbound$value,
        eqbound_type = function() private$..eqbound_type$value,
        alpha = function() private$..alpha$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value,
        low_eqbound_dz = function() private$..low_eqbound_dz$value,
        high_eqbound_dz = function() private$..high_eqbound_dz$value),
    private = list(
        ..pairs = NA,
        ..low_eqbound = NA,
        ..high_eqbound = NA,
        ..eqbound_type = NA,
        ..alpha = NA,
        ..desc = NA,
        ..plots = NA,
        ..low_eqbound_dz = NA,
        ..high_eqbound_dz = NA)
)

dataTOSTpairedResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        tost = function() private$.items[["tost"]],
        eqb = function() private$.items[["eqb"]],
        desc = function() private$.items[["desc"]],
        plots = function() private$.items[["plots"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="TOST Paired Samples T-Test")
            self$add(jmvcore::Table$new(
                options=options,
                name="tost",
                title="TOST Results",
                rows="(pairs)",
                clearWith=list(
                    "alpha",
                    "low_eqbound",
                    "high_eqbound",
                    "eqbound_type"),
                columns=list(
                    list(
                        `name`="i1", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)"),
                    list(
                        `name`="i2", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)"),
                    list(
                        `name`="b[0]", 
                        `title`="", 
                        `type`="text", 
                        `content`="t-test"),
                    list(
                        `name`="t[0]", 
                        `title`="t", 
                        `type`="number"),
                    list(
                        `name`="df[0]", 
                        `title`="df", 
                        `type`="integer"),
                    list(
                        `name`="p[0]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"),
                    list(
                        `name`="b[1]", 
                        `title`="", 
                        `type`="text", 
                        `content`="TOST Upper"),
                    list(
                        `name`="t[1]", 
                        `title`="t", 
                        `type`="number"),
                    list(
                        `name`="df[1]", 
                        `title`="df", 
                        `type`="integer"),
                    list(
                        `name`="p[1]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"),
                    list(
                        `name`="b[2]", 
                        `title`="", 
                        `type`="text", 
                        `content`="TOST Lower"),
                    list(
                        `name`="t[2]", 
                        `title`="t", 
                        `type`="number"),
                    list(
                        `name`="df[2]", 
                        `title`="df", 
                        `type`="integer"),
                    list(
                        `name`="p[2]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="eqb",
                title="Equivalence Bounds",
                rows="(pairs)",
                clearWith=list(
                    "alpha",
                    "low_eqbound",
                    "high_eqbound",
                    "eqbound_type"),
                columns=list(
                    list(
                        `name`="i1", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)"),
                    list(
                        `name`="i2", 
                        `title`="", 
                        `type`="text", 
                        `content`="($key)"),
                    list(
                        `name`="stat[cohen]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Cohen's d"),
                    list(
                        `name`="low[cohen]", 
                        `title`="Low", 
                        `type`="number"),
                    list(
                        `name`="high[cohen]", 
                        `title`="High", 
                        `type`="number"),
                    list(
                        `name`="cil[cohen]", 
                        `title`="Lower", 
                        `superTitle`="Confidence interval", 
                        `content`=""),
                    list(
                        `name`="ciu[cohen]", 
                        `title`="Upper", 
                        `superTitle`="Confidence interval", 
                        `content`=""),
                    list(
                        `name`="stat[raw]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Raw"),
                    list(
                        `name`="low[raw]", 
                        `title`="Low", 
                        `type`="number"),
                    list(
                        `name`="high[raw]", 
                        `title`="High", 
                        `type`="number"),
                    list(
                        `name`="cil[raw]", 
                        `title`="Lower", 
                        `superTitle`="Confidence interval"),
                    list(
                        `name`="ciu[raw]", 
                        `title`="Upper", 
                        `superTitle`="Confidence interval"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="desc",
                title="Descriptives",
                visible="(desc)",
                rows="(pairs)",
                clearWith=NULL,
                columns=list(
                    list(
                        `name`="name[1]", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="n[1]", 
                        `title`="N", 
                        `type`="integer"),
                    list(
                        `name`="m[1]", 
                        `title`="Mean", 
                        `type`="number"),
                    list(
                        `name`="med[1]", 
                        `title`="Median", 
                        `type`="number"),
                    list(
                        `name`="sd[1]", 
                        `title`="SD", 
                        `type`="number"),
                    list(
                        `name`="se[1]", 
                        `title`="SE", 
                        `type`="number"),
                    list(
                        `name`="name[2]", 
                        `title`="", 
                        `type`="text"),
                    list(
                        `name`="n[2]", 
                        `title`="N", 
                        `type`="integer"),
                    list(
                        `name`="m[2]", 
                        `title`="Mean", 
                        `type`="number"),
                    list(
                        `name`="med[2]", 
                        `title`="Median", 
                        `type`="number"),
                    list(
                        `name`="sd[2]", 
                        `title`="SD", 
                        `type`="number"),
                    list(
                        `name`="se[2]", 
                        `title`="SE", 
                        `type`="number"))))
            self$add(jmvcore::Array$new(
                options=options,
                name="plots",
                title="Plots",
                items="(pairs)",
                visible="(plots)",
                template=jmvcore::Image$new(
                    options=options,
                    title="$key",
                    renderFun=".plot",
                    width=180,
                    clearWith=list(
                        "alpha",
                        "low_eqbound",
                        "high_eqbound",
                        "eqbound_type"))))}))

dataTOSTpairedBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "dataTOSTpairedBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'TOSTER',
                name = 'dataTOSTpaired',
                version = c(1,0,0),
                options = options,
                results = dataTOSTpairedResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE)
        }))

#' TOST Paired Samples T-Test
#'
#' TOST Paired Samples T-Test
#'
#' @examples
#' library("TOSTER")
#'
#' dataTOSTpaired(data = randu, pairs = list(c(i1="x",i2="y")), low_eqbound = -0.3,
#'                high_eqbound = 0.3, alpha = 0.05, desc = TRUE, plots = TRUE)
#'
#' @section References:
#' Mara, C. A., & Cribbie, R. A. (2012). Paired-Samples Tests of Equivalence. Communications in Statistics - Simulation and Computation, 41(10), 1928-1943. https://doi.org/10.1080/03610918.2011.626545, formula page 1932. Note there is a typo in the formula: n-1 should be n (personal communication, 31-08-2016)
#'
#' @param data the data as a data frame
#' @param pairs a list of vectors of strings naming variables to pair from
#'   \code{data}
#' @param low_eqbound a number (default: 0.5) the lower equivalence bounds
#' @param high_eqbound a number (default: 0.5) the upper equivalence bounds
#' @param eqbound_type \code{'d'} (default) or \code{'raw'}; whether the
#'   bounds are specified in standardized mean difference (Cohen's dz) or raw
#'   units respectively
#' @param alpha alpha level (default = 0.05)
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   statistics
#' @param plots \code{TRUE} or \code{FALSE} (default), provide plots
#' @param low_eqbound_dz deprecated
#' @param high_eqbound_dz deprecated
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$tost} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$eqb} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$desc} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$plots} \tab \tab \tab \tab \tab an array of images \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$tost$asDF}
#'
#' \code{as.data.frame(results$tost)}
#'
#' @export
dataTOSTpaired <- function(
    data,
    pairs,
    low_eqbound = -0.5,
    high_eqbound = 0.5,
    eqbound_type = "d",
    alpha = 0.05,
    desc = FALSE,
    plots = FALSE,
    low_eqbound_dz = -999999999,
    high_eqbound_dz = -999999999) {

    if ( ! requireNamespace('jmvcore'))
        stop('dataTOSTpaired requires jmvcore to be installed (restart may be required)')

    options <- dataTOSTpairedOptions$new(
        pairs = pairs,
        low_eqbound = low_eqbound,
        high_eqbound = high_eqbound,
        eqbound_type = eqbound_type,
        alpha = alpha,
        desc = desc,
        plots = plots,
        low_eqbound_dz = low_eqbound_dz,
        high_eqbound_dz = high_eqbound_dz)

    results <- dataTOSTpairedResults$new(
        options = options)

    analysis <- dataTOSTpairedClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
