% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gdbsource.R
\name{gdbsource}
\alias{gdbsource}
\alias{print.backtrace}
\title{Source R-script through gdb to get backtrace.}
\usage{
gdbsource(file, interactive = FALSE)

\method{print}{backtrace}(x, ...)
}
\arguments{
\item{file}{Your R script}

\item{interactive}{Run interactive gdb session?}

\item{x}{Backtrace from \code{gdbsource}}

\item{...}{Not used}
}
\value{
Object of class \code{backtrace}
}
\description{
Source R-script through gdb to get backtrace.

If \code{gdbsource} is run non-interactively (the default) only
the relevant information will be printed. Note that this will only
work if the cpp file and the R file share the same base name.
}
\details{
This function is useful for debugging templates.
If a script aborts e.g. due to an out-of-bound index operation
it should be fast to locate the line that caused the problem by
running \code{gdbsource(file)}.
Alternatively, If more detailed debugging is required,  then
\code{gdbsource(file,TRUE)} will provide the full backtrace followed
by an interactive gdb session where the individual frames can be inspected.
Note that templates should be compiled without optimization and with debug
information in order to provide correct line numbers:
\itemize{
\item On Linux/OS X use \code{compile(cppfile,"-O0 -g")}.
\item On Windows use \code{compile(cppfile,"-O1 -g",DLLFLAGS="")} (lower
optimization level will cause errors).
}
}

