% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script_TL.import.R
\name{script_TL.import}
\alias{script_TL.import}
\title{Script for data pretreatment}
\usage{
script_TL.import(file.name, k = 1, protocol = "Unknown",
  file.parameters = list(file.extension = ".binx", folder.in = "./"),
  plotting.parameters = list(plot.Tmin = 0, plot.Tmax = NA, no.plot = FALSE))
}
\arguments{
\item{file.name}{\link{character} (\bold{required}): Name of the file containing the luminescence data.}

\item{k}{\link{numeric} (with default): Corrective factor for estimating the uncertainties using a poisson distribution.}

\item{protocol}{\link{character} (\bold{required}): Measurment protocol used.}

\item{file.parameters}{\link{list} (with default): list containing the file parameters. See details.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}
}
\value{
This function returns a \code{\linkS4class{TLum.Analysis}} object.
}
\description{
This script opens a .binx file and creates a \linkS4class{TLum.Analysis} object from it.
It just requires the name of the file with the TL curves and the relative error on the measurements.
It extracts the TL curves and updates the data types.
}
\details{
\bold{Plotting parameters} \cr
The plotting parameters are:  \cr
\describe{
 \item{\code{plot.Tmin}}{
   \link{numeric}: Lowest temperature plotted.}
 \item{\code{plot.Tmax}}{
   \link{numeric}: Highest temperature plotted.}
 \item{\code{no.plot}}{
   \link{logical}: If \code{TRUE}, the results will not be plotted.}
}
See also \link{plot_extract.TL}. \cr

\bold{File parameters} \cr
The file parameters are:  \cr
\describe{
 \item{\code{file.extension}}{
   \link{character} (with default): extension of the file containing the luminescence data (.bin or .binx)}
 \item{\code{folder.in}}{
   \link{character} (with default): Folder containing the file with the luminescene data.}
}
}
\author{
David Strebler, University of Cologne (Germany).
}
\seealso{
\link{read_BIN2R},
 \link{Risoe.BINfileData2TLum.BIN.File},
 \link{TLum.BIN.File2TLum.Analysis},
 \link{mod_extract.TL},
 \link{mod_update.dType}.
}

