% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.PWMs.R
\name{summary.PWMs}
\alias{summary.PWMs}
\title{Summary PWMs}
\usage{
\method{summary}{PWMs}(object, ci.level = 0.9, ...)
}
\arguments{
\item{object}{object of PWMs}

\item{ci.level}{numeric vector of length 1 giving the confidence level (default is 0.9).}

\item{...}{additional arguments submitted to \code{est_cov}.}
}
\value{
A \code{summary.PWMs}-object, a list with dimensions \itemize{
 \item \code{pwm}
 \item \code{ci.level}
 \item \code{ci}
 \item \code{cov}
}
It is printed with \code{print.summary.PWMs}.
}
\description{
Calculating and printing of summary statistics to a given PWMs-object.
}
\examples{
x <- cbind(rgev(100, shape = .2), rgev(100, shape = .2))

summary(PWMs(x[, 1]))
summary(PWMs(x[, 1]), distr = "gev")
summary(PWMs(x[, 1]), distr = "gev", select = 1:2)

summary(PWMs(x))
summary(PWMs(x), select = 1:2)

}
\seealso{
\code{\link{PWMs}}, \code{\link{est_cov}}
}
