% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TKCat.R, R/chTKCat.R, R/generics.R
\name{explore_MDBs.TKCat}
\alias{explore_MDBs.TKCat}
\alias{explore_MDBs.chTKCat}
\alias{explore_MDBs}
\title{Explore available \link{MDB} in a shiny web interface}
\usage{
\method{explore_MDBs}{TKCat}(
  x,
  subSetSize = 100,
  download = FALSE,
  workers = 4,
  title = NULL,
  skinColors = "green",
  logoDiv = TKCAT_LOGO_DIV,
  rDirs = NULL,
  tabTitle = "TKCat",
  tabIcon = "www/TKCat-small.png",
  ...
)

\method{explore_MDBs}{chTKCat}(
  x,
  subSetSize = 100,
  host = x$chcon@host,
  download = FALSE,
  workers = 4,
  userManager = NULL,
  title = NULL,
  skinColors = c("blue", "yellow"),
  logoDiv = TKCAT_LOGO_DIV,
  tabTitle = "chTKCat",
  tabIcon = "www/TKCat-small.png",
  rDirs = NULL,
  ...
)

explore_MDBs(x, ...)
}
\arguments{
\item{x}{a \link{TKCat} related object (e.g. \link{chTKCat})}

\item{subSetSize}{the maximum number of records to show}

\item{download}{a logical indicating if data can be downloaded
(default: FALSE). If TRUE a temporary directory is created and made
available for shiny.}

\item{workers}{number of available workers when download is available
(default: 4)}

\item{title}{A title for the application. If NULL (default):
the chTKCat instance name}

\item{skinColors}{two colors for the application skin: one for default
connection ("blue" by default) and one for user
connection ("yellow" by default).
Working values: "blue", "black", "purple", "green", "red", "yellow".}

\item{logoDiv}{a \link[shiny:reexports]{shiny::div} object with a logo to display in side bar.
The default is the TKCat hex sticker with a link to TKCat github repository.}

\item{rDirs}{a named character vector with resource path
for \link[shiny:resourcePaths]{shiny::addResourcePath}}

\item{tabTitle}{a title to display in tab (default: "chTKCat")}

\item{tabIcon}{a path to an image
(in available resource paths: "www", "doc" or in rDirs) to use as a tab icon.}

\item{...}{method specific parameters}

\item{host}{the name of the host to show in the application}

\item{userManager}{URL for user management interface
(see \code{\link[=manage_chTKCat_users]{manage_chTKCat_users()}}). If NULL (default), the functionality
is not added.}
}
\value{
No return value, called for side effects
}
\description{
Explore available \link{MDB} in a shiny web interface
}
