% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{compute_targetVal}
\alias{compute_targetVal}
\title{Compute target values for ensemble learning architecture}
\usage{
compute_targetVal(
  QC_num,
  sampleType,
  batchID,
  targetVal_method = c("mean", "median"),
  targetVal_batchWise = FALSE,
  targetVal_removeOutlier = !targetVal_batchWise,
  coerce_numeric = FALSE
)
}
\arguments{
\item{QC_num}{a numeric data.frame including the metabolite values of quality control (QC) samples. Missing values and infinite values will not be taken into account. Row: sample. Column: metabolite variable. See Examples.}

\item{sampleType}{a vector corresponding to \code{QC_num} to specify the type of each QC sample. QC samples of the \strong{same type} should have the \strong{same type name}. See Examples.}

\item{batchID}{a vector corresponding to \code{QC_num} to specify the batch of each sample. See Examples.}

\item{targetVal_method}{a character string specifying how the target values are computed. Can be \code{"mean"} (default) or \code{"median"}. See Details.}

\item{targetVal_batchWise}{logical. If \code{TRUE}, the target values will be computed based on each batch, otherwise, based on the whole dataset. Setting \code{TRUE} might be useful if your dataset has very obvious batch effects, but this may also make the algorithm less robust. See Details. Default: \code{FALSE}.}

\item{targetVal_removeOutlier}{logical. If \code{TRUE}, outliers will be removed before the computation. Outliers are determined with 1.5 * IQR (interquartile range) rule. We recommend turning this off when the target values are computed based on batches. See Details. Default: \code{!targetVal_batchWise}.}

\item{coerce_numeric}{logical. If \code{TRUE}, values in \code{QC_num} will be coerced to numeric before the computation. The columns cannot be coerced will be removed (with warnings). See Examples. Default: \code{FALSE}.}
}
\value{
If \code{targetVal_batchWise = FALSE}, the function returns a list of length one containing the target values computed on the whole dataset.

If \code{targetVal_batchWise = TRUE}, a list containing the target values computed on different batches is returned. The length of the returned list equals the number of batch specified by \code{batchID}.
}
\description{
This function provides an advanced option to calculate the target values of one reference dataset (i.e. \code{QC_num}, numeric values of quality control samples). The generated target values (a list) can be further passed to argument \code{targetVal_external} in function \code{\link{run_TIGER}} such that TIGER can align the \code{test_samples} with the reference dataset. This is useful for longitudinal datasets correction and cross-kit adjustment. See case study section of our original paper for detailed explanation.
}
\details{
See \code{\link{run_TIGER}}.
}
\examples{
data(FF4_qc) # load demo dataset
QC_num <- FF4_qc[-c(1:5)] # only contain numeric metabolite values.

# target values computed on the whole dataset:
tarVal_1 <- compute_targetVal(QC_num = QC_num,
                              sampleType = FF4_qc$sampleType,
                              batchID = FF4_qc$plateID,
                              targetVal_method = "mean",
                              targetVal_batchWise = FALSE,
                              targetVal_removeOutlier = TRUE)

# target values computed on batches:
tarVal_2 <- compute_targetVal(QC_num = QC_num,
                              sampleType = FF4_qc$sampleType,
                              batchID = FF4_qc$plateID,
                              targetVal_method = "mean",
                              targetVal_batchWise = TRUE,
                              targetVal_removeOutlier = FALSE)

# If coerce_numeric = TRUE,
# columns cannot be coerced to numeric will be removed (with warnings):
tarVal_3 <- compute_targetVal(QC_num = FF4_qc[-c(4:5)],
                              sampleType = FF4_qc$sampleType,
                              batchID = FF4_qc$plateID,
                              targetVal_method = "mean",
                              targetVal_batchWise = TRUE,
                              targetVal_removeOutlier = FALSE,
                              coerce_numeric = TRUE)
identical(tarVal_2, tarVal_3)  # identical to tarVal_2

\dontrun{

# will throw errors if input data have non-numeric columns
# and coerce_numeric = FALSE:

tarVal_4 <- compute_targetVal(QC_num = FF4_qc,
                              sampleType = FF4_qc$sampleType,
                              batchID = FF4_qc$plateID,
                              targetVal_method = "mean",
                              targetVal_batchWise = TRUE,
                              targetVal_removeOutlier = FALSE,
                              coerce_numeric = FALSE)
}
}
