% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmri_3dvisual.R
\name{fmri_3dvisual}
\alias{fmri_3dvisual}
\title{visualization of the 3D brain with the activated areas}
\usage{
fmri_3dvisual(
  pval,
  mask,
  p_threshold = 0.05,
  method = "scale_p",
  color_pal = "YlOrRd",
  multi_pranges = TRUE,
  title = NULL
)
}
\arguments{
\item{pval}{a 3D array of p-values used to plot activated area of the brain}

\item{mask}{a 3D nifti or 3D array of data to show the shell of the brain}

\item{p_threshold}{NULL or a numeric value that can be selected randomly below 0.05 to 
drop all p-values above the threshold. If 'low5_percent' method is used, 
make 'p_threshold' as NULL. The default is 0.05.}

\item{method}{a string that represents method for the plot.
There are 2 options: 'scale_p' and 'low5_percent'. The default is 'scale_p'. 
'scale_p' is to draw the plot with fixed color scale for fixed range of p value.
'low5_percent' is to draw the plot for the smallest 5 percent of p value when all the p values are not significant.}

\item{color_pal}{the name of the color palettes provided by \code{RColorBrewer}. The default is "YlOrRd".}

\item{multi_pranges}{an option under 'scale_p' method to decide whether there are at most 9 colors 
in the legend for the ranges of p value, or at most 4 colors. 
The default is TRUE, choosing the larger number of colors for the plot.}

\item{title}{the title of the plot. The default is NULL.}
}
\value{
a list of two elements
\itemize{
  \item plot - the 3d plot of the fMRI data drawn by \code{plotly}
  \item pval_df - data.frame with the p value for each voxel and the specified color for it
}
}
\description{
a visualization method, using \code{plotly} to draw the 3D plot of the brain 
with the activated areas determined by p-values, which is generated from fMRI data
}
\details{
The function \code{fmri_3dvisual} is used to visualize the 3D plot of the brain 
with its activated parts based on provided p values. The p values are generated by
applying statistical test on fMRI data. When providing input of a 3D p-values data, 
a 3D interactive plot will be generated with surface for the brain shell 
and scatter points in different colors and size representing different stimulated levels.
}
\examples{
# sample 3D data of mask provided by the package
dim(mask)
# sample 3D p value provided by the package
dim(phase2_pval)

# make the 3D plot
fmri_3dvisual(phase2_pval, mask, p_threshold = 0.05, method="scale_p")$plot

}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
