% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmri_image.R
\name{fmri_image}
\alias{fmri_image}
\title{interactive graph object of the fMRI image}
\usage{
fmri_image(fmridata, option = "manually", voxel_location = NULL, time = NULL)
}
\arguments{
\item{fmridata}{a 4D array contains information for the fMRI spacetime image. The data should only contain the magnitude for the fMRI image.}

\item{option}{The default is 'manually'. If choose 'auto', then this function will lead you to key in the space (x,y,z) parameters and time (time) parameter for this function to generate graphs.}

\item{voxel_location}{a 3D array indicating the spatial location of the brain. If option is auto, set the voxel_location as NULL.}

\item{time}{time location for the voxel}
}
\value{
an interactive graph object of the fMRI image created by \code{plotly}
}
\description{
fMRI image visualization method, based on package \code{plotly}.
}
\details{
The function \code{fmri_image} is used to create images for front view, side view, and top view of the fMRI image.
When providing the 4D array of the fMRI spacetime image and input the x,y,z position of the voxel, 
three views of the fMRI image and the time series image of the voxel will be shown.
}
\examples{
fmri_generate = fmri_simulate_func(dim_data = c(64, 64, 40), mask = mask)
fmri_image(fmri_generate$fmri_data, option='manually', voxel_location = c(40,22,33), time = 4)

}
\author{
SOCR team <\url{http://socr.umich.edu/people/}>
}
