% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uspr.R
\name{internals}
\alias{internals}
\alias{.CatchBadPair}
\alias{.DistReturn}
\title{Internal functions}
\usage{
.CatchBadPair(i, tree1, tree2)

.DistReturn(ret, tree1, tree2, allPairs)
}
\arguments{
\item{i}{Integer iterating tree pair.}

\item{tree1, tree2}{Trees of class \code{phylo}.}

\item{ret}{A list containing the results of a tree comparison, probably
performed in C.  Each element of the list will correspond to an aspect
of tree distance (e.g. TBR distance, MAF composition).}

\item{allPairs}{Logical specifying whether all trees were compared with all
other trees, in which case a structure of class \code{dist} will be returned for
numeric entries, and a symmetric matrix (with diagonal marked \code{NA}) returned
for non-numeric entries.}
}
\value{
\code{.CatchBadPair()} returns \code{integer(0)}, but will \code{stop} R with an
error message if the labels of \code{tree1} and \code{tree2} differ in anything but
order.

\code{.DistReturn()} returns a structure of class \code{numeric}, \code{matrix} or
\code{dist} containing the distances between each pair of trees.
}
\description{
These helper functions are unlikely to be of day-to-day use, but are
exported in case they are valuable to package developers.
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\keyword{internal}
