% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plus.R
\name{plus}
\alias{plus}
\title{Rename Plus Group Column}
\usage{
plus(x)
}
\arguments{
\item{x}{a data frame.}
}
\value{
A data frame similar to \code{x}, after renaming the last column.
}
\description{
Rename the last column in a data frame, by appending a \code{"+"} character.
This is useful if the last column is a plus group.
}
\note{
If the last column name already ends with a \code{"+"}, the original data
frame is returned without modifications.
}
\examples{
catage <- catage.taf

# Rename last column
catage <- plus(catage)

# Shorter and less error-prone than
names(catage)[names(catage)=="4"] <- "4+"

}
\seealso{
\code{\link{names}} is the underlying function to rename columns.

\code{\link{TAF-package}} gives an overview of the package.
}
