% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypercube_mesh.R
\name{hypercube_mesh}
\alias{hypercube_mesh}
\title{Generates a Cartesian mesh of d-dimensional scenarios based on the given ellipsoid. This function does not assume that the ellipsoid is centered at the origin.}
\usage{
hypercube_mesh(phi, hellip, normalize)
}
\arguments{
\item{phi}{The scalar fineness of the mesh}

\item{hellip}{The basis for the shocks; it must have measurable width in every dimension}

\item{normalize}{Whether to normalize points from the cube onto the sphere or not (TRUE/FALSE)}
}
\value{
A d x N array, with each column a scenario
}
\description{
Generates a Cartesian mesh of d-dimensional scenarios based on the given ellipsoid. This function does not assume that the ellipsoid is centered at the origin.
}
\examples{
hellip <- hyperellipsoid()
hypercube_mesh(3,hellip,TRUE)
}
