% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_bracket.R
\name{draw_bracket}
\alias{draw_bracket}
\title{Creates a bracket for tournaments involving 5 to 64 teams, single elimination}
\usage{
draw_bracket(
  teams,
  title = "Championship Bracket",
  text_size = 0.7,
  round_two = NULL,
  round_three = NULL,
  round_four = NULL,
  round_five = NULL,
  round_six = NULL,
  champion = NULL
)
}
\arguments{
\item{teams}{a list of teams, ordered by desired seed, to place in bracket.
Must be between 5 and 64 inclusive.  Teams must have unique names}

\item{title}{bracket title}

\item{text_size}{number passed to \code{cex} in plotting}

\item{round_two}{a list of teams advancing to the second round (need not be in
order)}

\item{round_three}{a list of teams advancing to the third round (need not be
in order)}

\item{round_four}{a list of teams advancing to the forth round (need not be in
order)}

\item{round_five}{a list of teams advancing to the fifth round (need not be in
order)}

\item{round_six}{a list of teams advancing to the fifth round (need not be in
order)}

\item{champion}{the name of the overall champion team (there can be only one)}
}
\value{
a plot of a bracket for the teams, with results and titles as
 specified
}
\description{
Will draw a single elimination bracket for the appropriate number of teams,
inserting first round byes for higher seeds as needed
}
\examples{
\dontrun{
teams <- c("red", "orange", "yellow", "green", "blue", "indigo", "violet")
round_two <- c("red", "yellow", "blue", "indigo")
round_three <- c("red", "blue")
champion <- "red"
draw_bracket(teams = teams,
             round_two = round_two,
             round_three = round_three,
             champion = champion)
}

}
\references{
based on \code{draw.bracket} from the seemingly now defunct
 \code{mRchmadness} package by Eli Shayer and Saber Powers and used per the
 terms of that package's GPL-2 license
}
