% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurveyDefense.R
\name{FraudDetec1}
\alias{FraudDetec1}
\title{Fraud Detection Analysis Tool 1}
\usage{
FraudDetec1(
  output_dir,
  data,
  FraudList,
  correct_answers = c(0, 0, 0, 0, 0),
  ...
)
}
\arguments{
\item{output_dir}{Path specifying where the Word and HTML files will be saved.}

\item{data}{The data frame containing all the survey data.}

\item{FraudList}{A character vector of up to 5 Fraud Detection Questions.}

\item{correct_answers}{A numeric vector representing correct answers for each question. Default is \code{c(0, 0, 0, 0, 0)}.}

\item{...}{Survey questions to be analyzed.}
}
\value{
A flextable object with the results.
}
\description{
Fraud Detection Analysis Tool 1
}
\examples{
if (requireNamespace("flextable", quietly = TRUE) && requireNamespace("officer", quietly = TRUE)) {
  library(flextable)
  library(officer)

  # Example data for fraud detection analysis
  Q1 <- c(4, 5, 3, 2, 5, 2)
  Q2 <- c(3, 4, 2, 5, 4, 3)
  Q3 <- c(5, 4, 3, 5, 4, 5)
  Q4 <- c(1, 2, 3, 4, 5, 2)
  Q5 <- c(5, 2, 2, 1, 4, 1)
  Q6 <- c(5, 2, 3, 5, 1, 2)
  Q7 <- c(5, 2, 4, 5, 3, 4)

  Fraud1 <- c(0, 1, 0, 0, 0, 0)
  Fraud2 <- c(0, 0, 0, 0, 0, 0)
  Fraud3 <- c(0, 1, 0, 0, 0, 0)
  Fraud4 <- c(0, 0, 1, 0, 0, 1)
  Fraud5 <- c(0, 0, 0, 1, 1, 1)

  Test_Data_Fraud <- data.frame(Q1, Q2, Q3, Q4, Q5, Q6, Q7, Fraud1, Fraud2, Fraud3, Fraud4, Fraud5)

  temp_dir <- tempdir()

  FraudDetec1(
    output_dir = temp_dir,
    data = Test_Data_Fraud,
    FraudList = c("Fraud1", "Fraud2", "Fraud3", "Fraud4", "Fraud5"),
    correct_answers = c(0, 0, 0, 0, 0),
    Q1, Q2, Q3, Q4, Q5, Q6, Q7
  )
}
}
