% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICA_BinCont_copula.R
\name{compute_ICA_BinCont}
\alias{compute_ICA_BinCont}
\title{Compute Individual Causal Association for a given D-vine copula model in the
Binary-Continuous Setting}
\usage{
compute_ICA_BinCont(
  copula_par,
  rotation_par,
  copula_family1,
  copula_family2 = copula_family1,
  n_prec,
  q_S0,
  q_S1,
  marginal_sp_rho = TRUE,
  seed = 1
)
}
\arguments{
\item{copula_par}{Parameter vector for the sequence of bivariate copulas that
define the D-vine copula. The elements of \code{copula_par} correspond to
\eqn{(c_{12}, c_{23}, c_{34}, c_{13;2}, c_{24;3}, c_{14;23})}.}

\item{rotation_par}{Vector of rotation parameters for the sequence of
bivariate copulas that define the D-vine copula. The elements of
\code{rotation_par} correspond to \eqn{(c_{12}, c_{23}, c_{34}, c_{13;2},
  c_{24;3}, c_{14;23})}.}

\item{copula_family1}{Copula family of \eqn{c_{12}} and \eqn{c_{34}}. For the
possible options, see \code{loglik_copula_scale()}.}

\item{copula_family2}{Copula family of the other bivariate copulas. For the
possible options, see \code{loglik_copula_scale()}.}

\item{n_prec}{Number of Monte Carlo samples for the computation of the mutual
information.}

\item{q_S0}{Quantile function for the distribution of \eqn{S_0}.}

\item{q_S1}{Quantile function for the distribution of \eqn{S_1}.}

\item{marginal_sp_rho}{(boolean) Compute the sample Spearman correlation
matrix? Defaults to \code{TRUE}.}

\item{seed}{Seed for Monte Carlo sampling. This seed does not affect the global
environment.}
}
\value{
(numeric) A Named vector with the following elements:
\itemize{
\item ICA
\item Spearman's rho, \eqn{\rho_s (\Delta S, \Delta T)} (if asked)
\item Kendall's tau, \eqn{\tau (\Delta S, \Delta T)} (if asked)
\item Marginal association parameters in terms of Spearman's rho:
\deqn{(\rho_s(S_0, S_1), \rho_s(S_0, T_0), \rho_s(S_0, T_1),
 \rho_s(S_1, T_0), \rho_s(S_0, S_1),
 \rho_s(T_0, T_1)}
}
}
\description{
The \code{\link[=compute_ICA_BinCont]{compute_ICA_BinCont()}} function computes the individual causal
association for a fully identified D-vine copula model in the setting with a
continuous surrogate endpoint and a binary true endpoint.
}
