% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeostTextureLibrarySharedRoxy.R
\name{circularDispersionNV}
\alias{circularDispersionNV}
\title{Compute circular variance of normal vectors to surface}
\usage{
circularDispersionNV(inraster, window)
}
\arguments{
\item{inraster}{The DEM from which compute the index}

\item{window}{The moving window adopted for computing the index}
}
\value{
The raster with the computed index
}
\description{
Compute circular variance of normal vectors to surface, using the resultant vector length
}
\examples{
#
#Normal vector dispersion using a circular search window of radius 3.
dem=rast(paste(system.file("extdata", package = "SurfRough"), "/trento1.tif",sep=""))
w=KernelCircular(3)
roughVDR=circularDispersionNV(dem,w)
plot(roughVDR)
}
