% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmatrix.R
\name{rmatrix}
\alias{rmatrix}
\title{Rotation matrix}
\usage{
rmatrix(dec, inc, mag, as.data.frame = FALSE)
}
\arguments{
\item{dec}{declination of the rotation axis; it is the angle from the
north taken on an horizontal plane. It is measured clockwise from North and
ranges from 0 to 360° (Tauxe 2010).}

\item{inc}{inclination of the rotation axis; it is the angle from the
horizontal, is positive downward, and ranges from +90° for straight down to
-90° for straight up (Tauxe, 2010).}

\item{mag}{magnitude of rotation (following the notation of the
Stereonet software) a positive rotation is clockwise looking in the direction
of the given declination and inclination)}

\item{as.data.frame}{logical, whether to output the matrix as a data
frame. This is used when multiple arguments are provided to simplify and
boost calculations.}
}
\description{
Computes a rotation matrix for a given rotation axis and angle
based on Tauxe et al. (2010).
}
\examples{
rmatrix(135,20,60)

rmatrix(c(135,0),c(20,90),c(60,90), as.data.frame = TRUE)

}
\references{
\itemize{
  \item Tauxe, L., 2010. Essentials of Paleomagnetism. University of
  California Press.
  \item Allmendinger, R. W., Cardozo, N. C., and Fisher, D., 2013, Structural
  Geology Algorithms: Vectors & Tensors: Cambridge, England, Cambridge
  University Press, 289 pp.
  \item Cardozo, N., and Allmendinger, R. W., 2013, Spherical projections
  with OSXStereonet: Computers & Geosciences, v. 51, no. 0, p. 193 - 205,
  doi: 10.1016/j.cageo.2012.07.021
}
}
