% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submod_otr.R
\name{predict.submod_otr}
\alias{predict.submod_otr}
\title{Predict submod: OTR CTREE}
\usage{
\method{predict}{submod_otr}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Trained ctree model.}

\item{newdata}{Data-set to make predictions at (Default=NULL, predictions correspond
to training data).}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Identified subgroups with subgroup-specific predictions of P(PLE>thres).
\itemize{
  \item Subgrps - Identified subgroups
  \item pred - Predictions, P(PLE>thres) by identified subgroup.
}
}
\description{
Predict subgroups and obtain subgroup-specific estimates, P(PLE>thres), for a
trained ctree OTR model.
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

\donttest{
## Estimate PLEs (through Ranger) ##
res.ple = ple_train(Y, A, X, Xtest=X, family="gaussian", ple="ple_ranger")

## Fit OTR Subgroup Model ##
res_otr = submod_otr(Y, A, X, Xtest=X, mu_train = res.ple$mu_train)
out = predict(res_otr, newdata=X)
plot(res_otr$mod)
}

}
