% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_ranger.R
\name{ple_ranger}
\alias{ple_ranger}
\title{Patient-level Estimates: Ranger}
\usage{
ple_ranger(Y, A, X, Xtest, byTrt = 1, min.node.pct = 0.1,
  family = "gaussian", ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate matrix. Must be numeric.}

\item{Xtest}{Test set}

\item{byTrt}{If 1, fit treatment-specific ranger models. If 0, fit a single ranger model
with covariate space (X, A, X*A)}

\item{min.node.pct}{Minimum sample size in forest nodes (n*min.node.pct)}

\item{family}{Outcome type ("gaussian", "binomial"), default is "gaussian"}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Patient-level estimates (E(Y|X,1), E(Y|X,0), E(Y|X,1)-E(Y|X,0)) for train/test sets.
 \itemize{
  \item mods - trained model(s)
  \item mu_train - Patient-level estimates (training set)
  \item mu_test - Patient-level estimates (test set)
}
}
\description{
Estimate patient-level estimates (PLEs) through treatment-specific
(or with explicit X*A interactions) random forest models (ranger).
Used for continuous or binary outcomes, with output estimates of E(Y|X,A=a) and
E(Y|X,A=1)-E(Y|X,A=0) (PLE).
}
\examples{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

\donttest{
# Default (treatment-specific ranger models) #
mod1 = ple_ranger(Y, A, X, Xtest=X)
summary(mod1$mu_train$PLE)

# Generate A*X covariates (single ranger model) #
mod2 = ple_ranger(Y, A, X, Xtest=X, byTrt=0)
summary(mod2$mu_train$PLE)
}

## Survival (TBD) ##

}
\seealso{
\code{\link{PRISM}}, \code{\link{ranger}}
}
