% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snd_niche.R
\name{snd_niche}
\alias{snd_niche}
\title{simple niche model}
\usage{
snd_niche(opt, tol, prob_modifier = 1, cutoff_val = NULL)
}
\arguments{
\item{opt}{optimum value, gradient value where collection probability is highest}

\item{tol}{tolerance to changes in gradient. For large values, collection probability drops off slower away from \code{opt}}

\item{prob_modifier}{collection probability modifier, collection probability at \code{opt}.}

\item{cutoff_val}{NULL or a number. If a number, all collection probabilities at gradient values below \code{cutoff_value} are set to 0. This can for example be used to model exclusively marine species when the gradient is water depth (see examples).}
}
\value{
a function for usage with \code{apply_niche}.
}
\description{
Defines niche model based in the "Probability of collection" model by Holland and Patzkowsky (1999).
The collection probability follows the shape of a bell curve across a gradient, where \code{opt} determines the peak (mean) of the bell curve, and \code{tol} the standard deviation. "snd" stands for "scaled normal distribution", as the collection probability has the shape of the probability density of the normal distribution.
}
\examples{

# using water depth as niche
wd = seq(-3, 40, by = 0.5)
f = snd_niche(opt = 10, tol = 5)

plot(wd, f(wd), xlab = "Water depth", ylab = "Prob. of collection")
# set cutoff value at to 0 to model non-terrestrial species.
f = snd_niche(opt = 10, tol = 5, cutoff_val = 0)
plot(wd, f(wd), xlab = "Water depth", ylab = "Prob. of collection")

# see also
#vignette("event_data")
#for examples how to use it for niche modeling



}
\references{
\itemize{
\item Holland, Steven M. and Patzkowsky, Mark E. 1999. "Models for simulating the fossil record." Geology. https://doi.org/10.1130/0091-7613(1999)027\%3C0491:MFSTFR\%3E2.3.CO;2
}
}
\seealso{
\itemize{
\item \code{\link[=apply_niche]{apply_niche()}} for usage of the returned function
\item \code{\link[=bounded_niche]{bounded_niche()}} for another niche model
\item \code{\link[=trivial_niche]{trivial_niche()}} to model organisms without niche specifications
\item \code{\link[=discrete_niche]{discrete_niche()}} and \code{\link[=discrete_gradient]{discrete_gradient()}} to define niches based on discrete categories
\item \code{vignette("advenced_functionality")} for details on how to create user defined niche models
}
}
