% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{methods}
\name{getNbStorms}
\alias{getNbStorms}
\alias{getNbStorms,stormsList-method}
\title{Getting the number of \code{storm}}
\usage{
getNbStorms(sts)

\S4method{getNbStorms}{stormsList}(sts)
}
\arguments{
\item{sts}{\code{stormsList}}
}
\value{
numeric, the number of \code{storm} objects.
}
\description{
The \code{getNbStorms()} returns the number of \code{storm} objects
in the given \code{stormsList} object.
}
\examples{
#Creating a stormsDataset
\donttest{
sds <- defStormsDataset()

#Getting storm track data for all storms near New Caledonia
sts <- defStormsList(sds=sds, loi = "New Caledonia")

#Getting the number of storms in the sts object
getNbStorms(sts)
}
}
