% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{methods}
\name{getBuffer}
\alias{getBuffer}
\alias{getBuffer,stormsList-method}
\title{Getting the buffered location of interest}
\usage{
getBuffer(sts)

\S4method{getBuffer}{stormsList}(sts)
}
\arguments{
\item{sts}{\code{stormsList}}
}
\value{
A \code{sf} object.
}
\description{
The \code{getBuffer()} function returns the buffered location
of interest from a \code{stormsList} object.
}
\examples{
\donttest{
#Creating a stormsDataset
sds <- defStormsDataset()

#Getting storm track data for all storms near New Caledonia
sts <- defStormsList(sds=sds, loi = "New Caledonia")

#Getting the buffered location of interest from the sts object
buff <- getBuffer(sts)
}
}
