% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotStats.R
\name{plotStats}
\alias{plotStats}
\title{Plot StochKit2R simulation statistics output data}
\usage{
plotStats(statsDirectory, indices)
}
\arguments{
\item{statsDirectory}{Character string with path to StochKit2 stats output directory}

\item{indices}{The species indices that will be plotted. The first species is index 1}
}
\value{
The ggplot object
}
\description{
\code{plotStats} Plots means and mean +/- one standard deviation of populations specified in \code{indices} in the StochKit2R stats output directory \code{statsDirectory}
}
\examples{
\dontrun{
#example using included dimer_decay.xml file
model <- system.file("dimer_decay.xml",package="StochKit2R")
#output written to ex_out directory (created in current working directory)
ssa(model,"ex_out",10,100,20,force=TRUE)
#plot the data for species 1,2 and 3 (all of them in the dimer decay model)
plotStats("ex_out/stats",c(1,2,3))
}
}

