% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_usms_xml2txt.R
\name{gen_usms_xml2txt}
\alias{gen_usms_xml2txt}
\title{Generating one or several usms directories from a javastics workspace
content}
\usage{
gen_usms_xml2txt(
  javastics = NULL,
  workspace = NULL,
  out_dir = NULL,
  usm = c(),
  stics_version = "latest",
  verbose = TRUE,
  dir_per_usm_flag = TRUE,
  java_cmd = "java",
  java_converter = FALSE,
  javastics_path = lifecycle::deprecated(),
  workspace_path = lifecycle::deprecated(),
  target_path = lifecycle::deprecated(),
  usms_list = lifecycle::deprecated()
)
}
\arguments{
\item{javastics}{Path of JavaSTICS. Optional (needed if the JavaSTICS
converter is used, java_converter set to TRUE in inputs)}

\item{workspace}{Path of a JavaSTICS workspace
(i.e. containing the STICS XML input files). Optional, if not provided
the current workspace stored in JavaSTICS preferences will be used.}

\item{out_dir}{The path of the directory where to create usms directories
(Optional), if not provided the JavaSTICS workspace will be used as root}

\item{usm}{List of usms to generate (Optional). If not provided, all
usms contained in workspace/usms.xml file will be generated.}

\item{stics_version}{the STICS files version to use (optional,
default to latest).}

\item{verbose}{Logical value for displaying information while running}

\item{dir_per_usm_flag}{logical, TRUE if one want to create one directory
per USM, FALSE if USM files are generated in the target_path
(only useful for usms_list of size one)}

\item{java_cmd}{For unix like systems, the java virtual machine command
name or executable path. Usefull only if the JavaSTICS command line
is used for generating files. "java" is the default system command,
but a full path to a java executable (other than the default one)
may be given}

\item{java_converter}{logical TRUE for using JavaStics command
(a JavaSTICS path must be set in the function inputs), FALSE otherwise}

\item{javastics_path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{javastics_path}
is no longer supported, use \code{javastics} instead.}

\item{workspace_path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{workspace_path}
is no longer supported, use \code{workspace} instead.}

\item{target_path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{target_path} is no
longer supported, use \code{out_dir} instead.}

\item{usms_list}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{usms_list} is no
longer supported, use \code{usm} instead.}
}
\value{
A list with named elements:
usms_path : created directories paths (for storing STICS input files),
files : generated files list (in JavaSTICS workspace origin),
copy_status : logical value vector, indicating if all files have been
generated for each usm
obs_copy_status : logical value vector, indicating if observation files
have been successfully copied in usms directories
}
\description{
The function creates sets of input files for one or multiple
usms from usms data stored in a JavaSTICS workspace. For multiple usms,
sets will be generated into individual folders named with usm names.
Observations files will be also copied if they are named \verb{[usm_name].obs}
For one usm, files will be generated either in the workspace directory
or in a subdirectory.
}
\examples{
\dontrun{
javastics <- "/path/to/JavaSTICS/folder"
workspace <- "/path/to/workspace"

# For all usms
gen_usms_xml2txt(javastics, workspace)

# For an usms list
usm <- c("usm1", "usm2")
gen_usms_xml2txt(javastics, workspace, usm)

}

}
