% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_usm_xl.R
\name{download_usm_xl}
\alias{download_usm_xl}
\title{Downloading an Excel usms data file example into a directory}
\usage{
download_usm_xl(
  file = NULL,
  out_dir = tempdir(),
  stics_version = "latest",
  overwrite = FALSE,
  verbose = FALSE,
  xl_name = lifecycle::deprecated(),
  version_name = lifecycle::deprecated(),
  dest_dir = lifecycle::deprecated(),
  ...
)
}
\arguments{
\item{file}{Name of an Excel file (optional, not used for the moment)}

\item{out_dir}{Directory path where to copy the Excel file
(optional, default: \code{tempdir()})}

\item{stics_version}{Name of the STICS version. Optional, by default
the latest version returned by get_stics_versions_compat() is used.}

\item{overwrite}{Optional logical, TRUE for overwriting files,
FALSE otherwise (default)}

\item{verbose}{Logical value for displaying information while running}

\item{xl_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{xl_name} is no
longer supported, use file instead.}

\item{version_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{version_name} is no
longer supported, use stics_version instead.}

\item{dest_dir}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{dest_dir} is no
longer supported, use out_dir instead.}

\item{...}{Additional arguments to be passed}
}
\value{
A vector of copied files path.
}
\description{
The file is an example that can be used for generating
JavaSTICS input files from parameters values stored in Excel spreadsheet
format (USMs, Ini, Soils, Tec, Station, ...). Each sheet contains parameters
values to insert into XML files, with the help of these functions:
\code{\link{gen_usms_xml}}, \code{\link{gen_sols_xml}},
\code{\link{gen_tec_xml}}, \code{\link{gen_sta_xml}},
\code{\link{gen_usms_xml}}, \code{\link{gen_ini_xml}}
}
\examples{

download_usm_xl()


}
