% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wlsPower.R
\name{compute_wlsPower}
\alias{compute_wlsPower}
\title{Compute Power via weighted least squares}
\usage{
compute_wlsPower(
  DesMat,
  EffSize,
  sigma,
  tau = 0,
  eta = NULL,
  tauAR = NULL,
  etaAR = NULL,
  rho = NULL,
  gamma = NULL,
  psi = NULL,
  N = NULL,
  CovMat = NULL,
  dfAdjust = "none",
  sig.level = 0.05,
  INDIV_LVL = FALSE,
  verbose = 1
)
}
\arguments{
\item{DesMat}{list, containing a matrix, the design matrix,
numeric timepoints, numeric total number of Clusters}

\item{EffSize}{raw effect, i.e. difference between mean under control and
mean under intervention}

\item{sigma}{numeric, residual error of cluster means if no N given.}

\item{tau}{numeric, standard deviation of random intercepts}

\item{eta}{numeric (scalar or matrix), standard deviation of random slopes.
If `eta` is given as scalar, `trtMat` is needed as well.}

\item{tauAR}{numeric (scalar), value between 0 and 1. Defaults to NULL.
If `tauAR` is not NULL, the random intercept `tau` is AR1-correlated.
*Currently not compatible with `rho`!=0 !*}

\item{etaAR}{numeric (scalar), value between 0 and 1. Defaults to NULL.
If `etaAR` is not NULL, the random slope `eta` is AR1-correlated.
*Currently not compatible with `rho`!=0 !*}

\item{rho}{numeric (scalar), correlation of `tau` and `eta`}

\item{gamma}{numeric (scalar), random time effect}

\item{psi}{numeric (scalar), random subject specific intercept.
Leads to a closed cohort setting}

\item{N}{numeric, number of individuals per cluster. Either a scalar, vector
of length #Clusters or a matrix of dimension #Clusters x timepoints.
Defaults to 'rep(1,sum(Cl))' if not passed.}

\item{CovMat}{numeric, a positive-semidefinite matrix with
(#Clusters \eqn{\cdot} timepoints) rows and columns. If `CovMat` is given,
`sigma`, `tau`, `eta`, `rho` and `psi` are ignored.}

\item{dfAdjust}{character, one of the following: "none","between-within",
"containment", "residual".}

\item{sig.level}{numeric (scalar), significance level, defaults to 0.05}

\item{INDIV_LVL}{logical, should the computation be conducted on an
individual level? This leads to longer run time and is
mainly for diagnostic purposes.}

\item{verbose}{integer, how much information should the function return?}
}
\value{
The return depends on the `verbose` parameter.
If `verbose`=0, only the power is returned
If `verbose`=1 (the default), a list containing power and the
parameters of the specific setting is returned.
If requested (by `verbose`=2) this list also contains relevant matrices.
}
\description{
This function calls `construct_DesMat` and `construct_CovMat` to
construct the design and covariance matrix, repectively. These matrices are
used to calculate the variance of the treatment effect estimator which is
then used to calculate the power to detect the assumed treatment effect.
}
