% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/freq2case.R
\name{freq2case}
\alias{freq2case}
\title{Convert frequency table to raw data}
\usage{
freq2case(x, var.names = NULL, freq.name = "Freq", freq.col = NULL, ...)
}
\arguments{
\item{x}{A table object, or a data frame in frequency form containing ranks and one
numeric variable representing the frequency for that rank.}

\item{var.names}{A list of variable names for the factors, if you wish to override those already in
the table.}

\item{freq.name}{The name of the frequency variable in the table.}

\item{freq.col}{The column index of the frequencies.}

\item{...}{Other arguments passed down to type.convert.}
}
\value{
A data frame containing the factors in the table and as many observations as are represented by the
total of the freq variable.
}
\description{
Convert frequency table to raw data(case form). This is a useful function to
convert the data written by Michael Friendly.
}
\examples{
data(APA)
cases = freq2case(APA, freq.col = 1)
freqs = case2freq(cases)
}
\author{
Michael Friendly, edited by Li Qinglong <liqinglong0830@163.com>
}
\references{
Posted on R-Help, Jan 20, 2009. \url{http://tolstoy.newcastle.edu.au/R/e6/help/09/01/1873.
html}
}

