\name{rg.mvalloc}
\alias{rg.mvalloc}
\title{ Robust Multivariate Allocation Procedure }
\description{
  Function to allocate an individual to one of several populations.
}
\usage{
rg.mvalloc(pcrit = 0.05, x, ...)
}
\arguments{
  \item{pcrit}{ When the probability of group membership is less than pcrit it is allocated to group 0. }
  \item{x}{ contains the individuals to be allocated }
  \item{\dots}{ arguments for creating a list of groups}
}
\details{
  m objects are the reference populations generated by md.gait, rg.robmva or rg.mva to estimate Mahalanobis distancesand predicted probabilities of group membership for individuals in matrix x.
  Note that the log |determinant| of the appropriate covariance matrix is added to the Mahalanobis distance on the assumption that the covariance matrices are inhomogeneous.
  If the data require transformation this must be undertaken before calling this function. This implies that a similar transformation must have been used for all the reference data subsets. 
}
\value{
 \item{groups}{the groups}
 \item{m}{number of groups}
 \item{n}{number of individuals to be allocated}
 \item{p}{number of columns}
 \item{pgm}{number of individuals to be allocated multiplied with the groups}
 \item{pcrit}{critical probability}
 \item{xalloc}{number of individuals as integer}
}
\references{ C. Reimann, P. Filzmoser, R.G. Garrett, and R. Dutter: Statistical Data Analysis
   Explained. Applied Environmental Statistics with R. John Wiley and Sons, Chichester, 2008. }
\author{ Peter Filzmoser <\email{P.Filzmoser@tuwien.ac.at}>
\url{http://cstat.tuwien.ac.at/filz/}}
\examples{
#input data
data(ohorizon)
vegzn=ohorizon[,"VEG_ZONE"]
veg=rep(NA,nrow(ohorizon))
veg[vegzn=="BOREAL_FOREST"] <- 1
veg[vegzn=="FOREST_TUNDRA"] <- 2
veg[vegzn=="SHRUB_TUNDRA"] <- 3
veg[vegzn=="DWARF_SHRUB_TUNDRA"] <- 3
veg[vegzn=="TUNDRA"] <- 3
el=c("Ag","Al","As","B","Ba","Bi","Ca","Cd","Co","Cu","Fe","K","Mg","Mn",
  "Na","Ni","P","Pb","Rb","S","Sb","Sr","Th","Tl","V","Y","Zn")
x <- log10(ohorizon[!is.na(veg),el])
v <- veg[!is.na(veg)]

res.zone1=rg.mva(as.matrix(x[v==1,]))
res.zone2=rg.mva(as.matrix(x[v==2,]))
res.zone3=rg.mva(as.matrix(x[v==3,]))
res=rg.mvalloc(pcrit=0.01,x,res.zone1,res.zone2,res.zone3)
}
\keyword{ multivariate }
\keyword{ robust }
