% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mortality_model.R
\name{boxplot_post_dist}
\alias{boxplot_post_dist}
\title{Boxplot for the posterior distribution}
\usage{
boxplot_post_dist(stan_fit, parm_name, ages, years)
}
\arguments{
\item{stan_fit}{stan fit object}

\item{parm_name}{string to indicate the name of the parameter, to choose from c('a', 'b', 'g', 'k', 'k2', 'phi')}

\item{ages}{range of ages}

\item{years}{range of years}
}
\value{
Posterior distribution shown as boxplots
}
\description{
The function generates boxplots for the posterior distribution of the main parameters
}
\examples{


years <- 1990:2017
ages <- 50:90
cohorts <- sort(unique(as.vector(sapply(years, function(year) year - ages))))
death <- FRMaleData$Dxt[formatC(ages),formatC(years)]
exposure <- FRMaleData$Ext[formatC(ages),formatC(years)]
iterations<-50 # Toy example, consider at least 2000 iterations
stan_fit <- fit_mo_mo("m6", death , exposure, ages, 0, 5, "nb", 1, 4,
log_marg = FALSE,iter=iterations)
boxplot_post_dist(stan_fit, "k", ages, years)
boxplot_post_dist(stan_fit, "g", ages, years)


}
