% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/standardModels.R
\name{rh}
\alias{rh}
\title{Create a Renshaw and Haberman (Lee-Carter with cohorts) mortality model}
\usage{
rh(link = c("log", "logit"), cohortAgeFun = c("1", "NP"))
}
\arguments{
\item{link}{defines the link function and random component associated with
  the mortality model. \code{"log"} would assume that deaths follow a Poisson
  distribution and use a log link while \code{"logit"} would assume that
  deaths follow a Binomial distribution and a logit link.}

\item{cohortAgeFun}{defines the cohort age modulating parameter
  \eqn{\beta_x^{(0)}}. It can take values: \code{"NP"} for a non-parametric age
  term or \code{"1"} for \eqn{\beta_x^{(0)}=1} (the default).}
}
\value{
An object of class \code{"StMoMo"}.
}
\description{
Utility function to initialise a \code{StMoMo} object representing a
Renshaw and Haberman (Lee-Carter with cohorts) mortality model introduced
in Renshaw and Haberman (2006).
}
\details{
The created model is either a log-Poisson or a
logit-Binomial version of the Renshaw and Haberman model which has
predictor structure
\deqn{\eta_{xt} = \alpha_x + \beta^{(1)}_x\kappa_t + \beta^{(0)} \gamma_{t-x}.}
or
\deqn{\eta_{xt} = \alpha_x + \beta^{(1)}_x\kappa_t + \gamma_{t-x}.}
depending on the value of argument \code{cohortAgeFun}.

To ensure identifiability the  following constraints are imposed
\deqn{\sum_t\kappa_t = 0, \sum_x\beta^{(1)}_x = 1, \sum_c\gamma_c = 0}
plus
\deqn{\sum_x\beta^{(0)}_x = 1}
if \code{cohortAgeFun = "NP"}

By default \eqn{\beta^{(0)}_x = 1} as this model has shown to be more
stable (see Haberman and Renshaw (2011) and Hunt and Villegas (2014)).
}
\examples{
LCfit <-  fit(lc(), Dxt = EWMaleData$Dxt, Ext = EWMaleData$Ext,
               ages = EWMaleData$ages, years = EWMaleData$years,
               ages.fit = 55:89)
wxt <- genWeightMat(55:89,  EWMaleData$years, clip = 3)
RHfit <- fit(rh(), Dxt = EWMaleData$Dxt, Ext = EWMaleData$Ext,
              ages = EWMaleData$ages, years = EWMaleData$years,
              ages.fit = 55:89, wxt = wxt, start.ax = LCfit$ax,
              start.bx = LCfit$bx, start.kt = LCfit$kt)
plot(RHfit)
}
\references{
Haberman, S., & Renshaw, A. (2011). A comparative study of parametric mortality projection
models. Insurance: Mathematics and Economics, 48(1), 35-55.

Hunt, A., & Villegas, A. M. (2014). Robustness and convergence in the Lee-Carter model
with cohorts. Working Paper.

Renshaw, A. E., & Haberman, S. (2006). A cohort-based extension to the Lee-Carter model
for mortality reduction factors.Insurance: Mathematics and Economics, 38(3), 556-570.
}
\seealso{
\code{\link{StMoMo}}, \link{lc}, \link{apc}
}

