/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.sql;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.ohdsi.sql.SqlRender;
import org.ohdsi.sql.SqlTranslate;

public class MainClass {
    public static void main(String[] args) {
        int i;
        if (args.length < 4 || args.length > 0 && (args[0].toLowerCase().equals("-usage") || args[0].toLowerCase().equals("-help") || args[0].toLowerCase().equals("?"))) {
            MainClass.printUsage();
            return;
        }
        String sql = MainClass.readFile(args[0]);
        for (int i2 = 2; i2 < args.length; ++i2) {
            if (!args[i2].equals("-render")) continue;
            ArrayList<String> parameters = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (int j = i2 + 1; !(j >= args.length - 1 || args[j].equals("-translate") || args[j].equals("-oracle_temp_schema") || args[j].equals("-session_id")); j += 2) {
                parameters.add(args[j]);
                values.add(args[j + 1]);
            }
            sql = SqlRender.renderSql(sql, parameters.toArray(new String[parameters.size()]), values.toArray(new String[parameters.size()]));
        }
        String oracleTempSchema = null;
        for (int i3 = 2; i3 < args.length - 1; ++i3) {
            if (!args[i3].equals("-oracle_temp_schema")) continue;
            oracleTempSchema = args[i3 + 1];
            break;
        }
        String sessionId = null;
        for (i = 2; i < args.length - 1; ++i) {
            if (!args[i].equals("-session_id")) continue;
            sessionId = args[i + 1];
            break;
        }
        for (i = 2; i < args.length - 1; ++i) {
            if (!args[i].equals("-translate")) continue;
            String targetDialect = args[i + 1];
            sql = SqlTranslate.translateSql(sql, targetDialect, sessionId, oracleTempSchema);
        }
        MainClass.writeFile(sql, args[1]);
    }

    private static void printUsage() {
        System.out.println("SqlRender");
        System.out.println("  Translates OHDSI SQL into one of the supported target SQL dialects, and renders the SQL according to user-specified parameters. See https://github.com/OHDSI/SqlRender for details.");
        System.out.println("");
        System.out.println("Usage");
        System.out.println("  java -jar SqlRender.jar <input file> <output file> [options]");
        System.out.println("");
        System.out.println("Options");
        System.out.println("  -render {<name> <value>} ...    Render the SQL with a list of parameter name-value pairs");
        System.out.println("  -translate <target dialect>     Translate the input SQL to the target dialect");
        System.out.println("  -oracle_temp_schema <schema>    When translating to Oracle SQL, use this schema to emulate temp tables");
        System.out.println("  -session_id <session id>        When translating to Oracle SQL, use this ID to make emulated temp table names unique. Should be 8 chars long");
        System.out.println("");
        System.out.println("Examples");
        System.out.println("  java -jar SqlRender.jar in.sql out.sql -translate postgresql");
        System.out.println("  java -jar SqlRender.jar in.sql out.sql -translate oracle -render cdm_database_schema cdm_synpuf target_database_schema scratch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String fileName) {
        StringBuilder text = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(fileName));
            String line = bufferedReader.readLine();
            while (line != null) {
                text.append(line);
                text.append('\n');
                line = bufferedReader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return text.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String sql, String fileName) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }
}

