% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_glm.R
\name{p_glm}
\alias{p_glm}
\alias{gen_glm}
\title{p-value from (generalized) linear regression model simulations with fixed predictors}
\usage{
p_glm(
  formula,
  X,
  betas,
  test,
  sigma = NULL,
  family = gaussian(),
  gen_fun = gen_glm,
  ...
)

gen_glm(formula, X, betas, sigma = NULL, family = gaussian(), ...)
}
\arguments{
\item{formula}{formula passed to either \code{\link{lm}} or
\code{\link{glm}}}

\item{X}{a data.frame containing the covariates}

\item{betas}{vector of slope coefficients that match the
\code{model.matrix} version of \code{X}}

\item{test}{character vector specifying the test to pass to
\code{\link[car]{lht}}. Can also be a list of character vectors
to evaluate multiple tests}

\item{sigma}{residual standard deviation for linear model. Only
used when \code{family = 'gaussian'}}

\item{family}{family of distributions to use (see \code{\link{family}})}

\item{gen_fun}{function used to generate the required discrete data.
Object returned must be a \code{data.frame}. Default uses \code{\link{gen_glm}}.
User defined version of this function must include the argument \code{...}}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}
}
\value{
a single p-value
}
\description{
p-values associated with (generalized) linear regression model.
Requires a prespecified design matrix (\code{X}).
}
\examples{

X <- data.frame(G = factor(rep(c('control', 'treatment'), each=50)),
                C = sample(50:100, 100, replace=TRUE))
head(X)

# ANCOVA setup
p_glm(y ~ G + C, test="Gtreatment = 0",
  X=X, betas=c(10, .3, 1), sigma=1)

# ANCOVA setup with logistic regression
p_glm(y ~ G + C, test="Gtreatment = 0",
  X=X, betas=c(-2, .5, .01), family=binomial())

# ANCOVA setup with poisson regression
p_glm(y ~ G + C, test="Gtreatment = 0",
  X=X, betas=c(-2, .5, .01), family=poisson())


}
\seealso{
\code{\link{p_lm.R2}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
