% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.cv.SplitReg}
\alias{predict.cv.SplitReg}
\title{Make predictions from a cv.SplitReg object.}
\usage{
\method{predict}{cv.SplitReg}(
  object,
  newx,
  index = object$index_opt,
  type = c("response", "coefficients"),
  ...
)
}
\arguments{
\item{object}{Fitted cv.SplitReg object.}

\item{newx}{Matrix of new values of x at which prediction are to be made. Ignored if type is "coefficients".}

\item{index}{Indices indicating values of lambda_S at which to predict. Defaults to the optimal value.}

\item{type}{Either "response" for predicted values or "coefficients" for the estimated coefficients.}

\item{...}{Additional arguments for compatibility}
}
\value{
Either a matrix with predictions or a vector of coefficients
}
\description{
Make predictions from a cv.SplitReg object, similar to other predict methods.
}
\examples{
library(MASS)
set.seed(1)
beta <- c(rep(5, 5), rep(0, 45))
Sigma <- matrix(0.5, 50, 50)
diag(Sigma) <- 1
x <- mvrnorm(50, mu = rep(0, 50), Sigma = Sigma)
y <- x \%*\% beta + rnorm(50)
fit <- cv.SplitReg(x, y, num_models=2)
x.new <- mvrnorm(50, mu = rep(0, 50), Sigma = Sigma)
split.predictions <- predict(fit, newx = x.new, type="response")

}
\seealso{
\code{\link{predict.cv.SplitReg}}
}
