\name{summary.predCVSTmodel}
\alias{summary.predCVSTmodel}
\title{Computes summary details for \code{predCVSTmodel} object}
\usage{
  \method{summary}{predCVSTmodel} (object,
    pred.naive = NULL, by.date = FALSE, p = 0.95,
    transform = function(x) {     return(x) }, LTA = FALSE,
    ...)
}
\arguments{
  \item{object}{\code{predCVSTmodel} object to compute
  summary information for; the output from
  \code{\link{predictCV.STmodel}}.}

  \item{pred.naive}{Result of naive prediction; used to
  compute modified R2 values. The output from
  \code{\link{predictNaive}}.}

  \item{by.date}{Compute individual cross-validation
  statistics for each time-point. May lead to \emph{very
  many} statistics.}

  \item{p}{Approximate coverage of the computed confidence
  bands; the confidence bands are used when computing
  coverage of the cross-validated predictions.}

  \item{transform}{Transform observations and predictions
  \emph{before} computing statistics; see also
  \code{\link{computeLTA}}}

  \item{LTA}{Compute cross-validation statistics for the
  long term averages at each site, uses
  \code{\link{computeLTA}} to compute the averages.
  \code{transform} is passed to \code{\link{computeLTA}}.}

  \item{...}{Ignored additional arguments.}
}
\value{
  A \code{summary.predCVSTmodel} object.
}
\description{
  \code{\link[base:summary]{summary}} method for class
  \code{predCVSTmodel}.
}
\details{
  Computes summary statistics for cross validation.
  Statistics that are computed include RMSE, R2, and
  coverage of CI:s; both for all observations and
  (possibly) stratified by date.
}
\examples{
##load some data
data(CV.mesa.model)

##basic summary statistics
summary(pred.cv.mesa)
##computed on the natural scale, and with long term averages
summary(pred.cv.mesa, transform=exp, LTA=TRUE)

##store the results
cv.summary <- summary(pred.cv.mesa, transform=exp, LTA=TRUE)
##and study the contents
str(cv.summary)
}
\author{
  Johan Lindstrm
}
\seealso{
  Other predCVSTmodel methods:
  \code{\link{estimateCV.STmodel}},
  \code{\link{plot.predCVSTmodel}},
  \code{\link{plot.predictSTmodel}},
  \code{\link{predictCV.STmodel}},
  \code{\link{print.predCVSTmodel}},
  \code{\link{print.summary.predCVSTmodel}}
}

