% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadData.R
\name{createSpatialDDLSobject}
\alias{createSpatialDDLSobject}
\title{Create a \code{\linkS4class{SpatialDDLS}} object}
\usage{
createSpatialDDLSobject(
  sc.data,
  sc.cell.ID.column,
  sc.cell.type.column,
  sc.gene.ID.column,
  st.data,
  st.spot.ID.column,
  st.gene.ID.column,
  sc.filt.genes.cluster = FALSE,
  sc.min.mean.counts = 0,
  sc.filt.genes.cells = TRUE,
  sc.min.counts = 0,
  sc.min.cells = 0,
  st.min.counts = 0,
  st.min.spots = 0,
  st.n.slides = 3,
  shared.genes = TRUE,
  sc.name.dataset.h5 = NULL,
  sc.file.backend = NULL,
  sc.name.dataset.backend = NULL,
  sc.compression.level = NULL,
  sc.chunk.dims = NULL,
  sc.block.processing = FALSE,
  verbose = TRUE,
  project = "SpatialDDLS-Proj"
)
}
\arguments{
\item{sc.data}{Single-cell RNA-seq profiles to be used as reference. If data
are provided from files, \code{single.cell.real} must be a vector of three
elements: single-cell counts, cells metadata and genes metadata. On the
other hand, If data are provided from a
\code{\linkS4class{SingleCellExperiment}} object, single-cell counts must
be present in the \code{assay} slot, cells metadata in the \code{colData}
slot, and genes metadata in the \code{rowData} slot.}

\item{sc.cell.ID.column}{Name or number of the column in cells metadata
corresponding to cell names in expression matrix (single-cell RNA-seq
data).}

\item{sc.cell.type.column}{Name or column number corresponding to cell types
in cells metadata.}

\item{sc.gene.ID.column}{Name or number of the column in genes metadata
corresponding to the names used for features/genes (single-cell RNA-seq
data).}

\item{st.data}{Spatial transcriptomics datasets to be deconvoluted. It can be
a single \code{\linkS4class{SpatialExperiment}} object or a list of them.}

\item{st.spot.ID.column}{Name or number of the column in spots metadata
corresponding to spot names in expression matrix (spatial transcriptomics
data).}

\item{st.gene.ID.column}{Name or number of the column in the genes metadata
corresponding to the names used for features/genes (spatial transcriptomics
data).}

\item{sc.filt.genes.cluster}{Whether to filter single-cell RNA-seq genes
according to a minimum threshold of mean counts per cell type
\code{sc.min.mean.counts}.}

\item{sc.min.mean.counts}{Minimum mean counts per cluster to filter genes.}

\item{sc.filt.genes.cells}{Whether to filter single-cell RNA-seq genes
according to a minimum number of counts \code{sc.min.counts} in a minimum
number of cells \code{sc.min.cells}.}

\item{sc.min.counts}{Minimum gene counts to filter (0 by default; single-cell
RNA-seq data).}

\item{sc.min.cells}{Minimum of cells with more than \code{min.counts} (0 by
default; single-cell RNA-seq data).}

\item{st.min.counts}{Minimum gene counts to filter (0 by default; spatial
transcriptomics data).}

\item{st.min.spots}{Minimum of cells with more than \code{min.counts} (0 by
default; spatial transcriptomics data).}

\item{st.n.slides}{Minimum number of slides
(\code{\linkS4class{SpatialExperiment}} objects) in which a gene has to be
expressed in order to keep it. This parameter is applicable only when
multiple \code{\linkS4class{SpatialExperiment}} objects are provided. Genes
not present in at least \code{st.n.slides} will be discarded. If no
filtering is desired, set \code{st.n.slides = 1}.}

\item{shared.genes}{If set to \code{TRUE}, only genes present in both the
isngle-cell and spatial transcriptomics data will be retained for further
processing (\code{TRUE} by default).}

\item{sc.name.dataset.h5}{Name of the data set if HDF5 file is provided for
single-cell RNA-seq data.}

\item{sc.file.backend}{Valid file path where to store the loaded for
single-cell RNA-seq data as HDF5 file. If provided, data are stored in a
HDF5 file as back-end using the \pkg{DelayedArray} and \pkg{HDF5Array}
packages instead of being loaded into RAM. This is suitable for situations
where you have large amounts of data that cannot be stored in memory. Note
that operations on these data will be performed by blocks (i.e subsets of
determined size), which may result in longer execution times. \code{NULL}
by default.}

\item{sc.name.dataset.backend}{Name of the HDF5 file dataset to be used. Note
that it cannot exist. If \code{NULL} (by default), a random dataset name
will be generated.}

\item{sc.compression.level}{The compression level used if
\code{sc.file.backend} is provided. It is an integer value between 0 (no
compression) and 9 (highest and slowest compression). See
\code{?\link[HDF5Array]{getHDF5DumpCompressionLevel}} from the
\pkg{HDF5Array} package for more information.}

\item{sc.chunk.dims}{Specifies dimensions that HDF5 chunk will have. If
\code{NULL}, the default value is a vector of two items: the number of
genes considered by \code{\linkS4class{SpatialDDLS}} object during the
simulation, and only one sample in order to increase read times in the
following steps. A larger number of columns written in each chunk may lead
to longer read times.}

\item{sc.block.processing}{Boolean indicating whether single-cell RNA-seq
data should be treated as blocks (only if data are provided as HDF5 file).
\code{FALSE} by default. Note that using this functionality is suitable for
cases where it is not possible to load data into RAM and therefore
execution times will be longer.}

\item{verbose}{Show informative messages during the execution (\code{TRUE} by
default).}

\item{project}{Name of the project for \code{\linkS4class{SpatialDDLS}}
object.}
}
\value{
A \code{\linkS4class{SpatialDDLS}} object with the single-cell
RNA-seq data provided loaded into the \code{single.cell.real} slot as a
\code{\linkS4class{SingleCellExperiment}} object. If spatial
transcriptomics data are provided, they will be loaded into the
\code{spatial.experiments} slot.
}
\description{
Create a \code{\linkS4class{SpatialDDLS}} object by providing single-cell
RNA-seq data. Additionally, spatial transcriptomics data contained in
\code{\linkS4class{SpatialDDLS}} objects can also be provided. It is
recommended to provide both types of data to calculate the intersection of
genes shared between both experiments.
}
\details{
\strong{Single-cell RNA-seq data}

Single-cell RNA-seq data can be provided from files (formats allowed: tsv,
tsv.gz, mtx (sparse matrix) and hdf5) or a
\code{\linkS4class{SingleCellExperiment}} object. Data will be stored in the
\code{single.cell.real} slot, and must consist of three pieces of
information: \itemize{ \item Single-cell counts: genes as rows and cells as
columns. \item Cells metadata: annotations (columns) for each cell (rows).
\item Genes metadata: annotations (columns) for each gene (rows). } If data
are provided from files, \code{single.cell.real} argument must be a vector of
three elements ordered so that the first file corresponds to the count
matrix, the second to the cells metadata, and the last to the genes metadata.
On the other hand, if data are provided as a
\code{\linkS4class{SingleCellExperiment}} object, it must contain single-cell
counts in \code{assay}, cells metadata in \code{colData}, and genes metadata
in \code{rowData}. Data must be provided without any transformation (e.g.
log-transformation), raw counts are preferred.

\strong{Spatial transcriptomics data}

It must be a \code{\linkS4class{SpatialExperiment}} object (or a list of them
if more than one slide is going to be deconvoluted) containing the same
information as the single-cell RNA-seq data: the count matrix, spots
metadata, and genes metadata. Please, make sure the gene identifiers used the
spatial and single-cell transcriptomics data are consistent.
}
\examples{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(100, lambda = 5), nrow = 40, ncol = 30,
      dimnames = list(paste0("Gene", seq(40)), paste0("RHC", seq(30)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(30)),
    Cell_Type = sample(x = paste0("CellType", seq(4)), size = 30,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(40))
  )
)
counts <- matrix(
  rpois(30, lambda = 5), ncol = 6,
  dimnames = list(paste0("Gene", 1:5), paste0("Spot", 1:6))
)
coordinates <- matrix(
  c(1, 2, 3, 1, 2, 3, 1, 2, 3, 1, 2, 3), ncol = 2
)
ste <- SpatialExperiment::SpatialExperiment(
  assays = list(counts = as.matrix(counts)),
  rowData = data.frame(Gene_ID = paste0("Gene", 1:5)),
  colData = data.frame(Cell_ID = paste0("Spot", 1:6)),
  spatialCoords = coordinates
)

SDDLS <- createSpatialDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  st.data = ste,
  st.spot.ID.column = "Cell_ID",
  st.gene.ID.column = "Gene_ID",
  project = "Simul_example"
)
  
}
\seealso{
\code{\link{estimateZinbwaveParams}} \code{\link{genMixedCellProp}}
}
