% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLContext.R
\name{createDataFrame}
\alias{createDataFrame}
\alias{createDataFrame.default}
\alias{as.DataFrame.default}
\alias{as.DataFrame}
\title{Create a SparkDataFrame}
\usage{
\method{createDataFrame}{default}(data, schema = NULL, samplingRatio = 1, numPartitions = NULL)

\method{as.DataFrame}{default}(data, schema = NULL, samplingRatio = 1, numPartitions = NULL)

as.DataFrame(data, ...)
}
\arguments{
\item{data}{a list or data.frame.}

\item{schema}{a list of column names or named list (StructType), optional.}

\item{samplingRatio}{Currently not used.}

\item{numPartitions}{the number of partitions of the SparkDataFrame. Defaults to 1, this is
limited by length of the list or number of rows of the data.frame}

\item{...}{additional argument(s).}
}
\value{
A SparkDataFrame.
}
\description{
Converts R data.frame or list into SparkDataFrame.
}
\note{
createDataFrame since 1.4.0

as.DataFrame since 1.6.0
}
\examples{
\dontrun{
sparkR.session()
df1 <- as.DataFrame(iris)
df2 <- as.DataFrame(list(3,4,5,6))
df3 <- createDataFrame(iris)
df4 <- createDataFrame(cars, numPartitions = 2)
}
}
