% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\docType{methods}
\name{select}
\alias{select}
\alias{$}
\alias{$,SparkDataFrame-method}
\alias{$<-}
\alias{$<-,SparkDataFrame-method}
\alias{select,SparkDataFrame,character-method}
\alias{select,SparkDataFrame,Column-method}
\alias{select,SparkDataFrame,list-method}
\title{Select}
\usage{
select(x, col, ...)

\S4method{$}{SparkDataFrame}(x, name)

\S4method{$}{SparkDataFrame}(x, name) <- value

\S4method{select}{SparkDataFrame,character}(x, col, ...)

\S4method{select}{SparkDataFrame,Column}(x, col, ...)

\S4method{select}{SparkDataFrame,list}(x, col)
}
\arguments{
\item{x}{a SparkDataFrame.}

\item{col}{a list of columns or single Column or name.}

\item{...}{additional column(s) if only one column is specified in \code{col}.
If more than one column is assigned in \code{col}, \code{...}
should be left empty.}

\item{name}{name of a Column (without being wrapped by \code{""}).}

\item{value}{a Column or an atomic vector in the length of 1 as literal value, or \code{NULL}.
If \code{NULL}, the specified Column is dropped.}
}
\value{
A new SparkDataFrame with selected columns.
}
\description{
Selects a set of columns with names or Column expressions.
}
\note{
$ since 1.4.0

$<- since 1.4.0

select(SparkDataFrame, character) since 1.4.0

select(SparkDataFrame, Column) since 1.4.0

select(SparkDataFrame, list) since 1.4.0
}
\examples{
\dontrun{
  select(df, "*")
  select(df, "col1", "col2")
  select(df, df$name, df$age + 1)
  select(df, c("col1", "col2"))
  select(df, list(df$name, df$age + 1))
  # Similar to R data frames columns can also be selected using $
  df[,df$age]
}
}
\seealso{
Other SparkDataFrame functions: \code{\link{SparkDataFrame-class}},
  \code{\link{agg}}, \code{\link{alias}},
  \code{\link{arrange}}, \code{\link{as.data.frame}},
  \code{\link{attach,SparkDataFrame-method}},
  \code{\link{broadcast}}, \code{\link{cache}},
  \code{\link{checkpoint}}, \code{\link{coalesce}},
  \code{\link{collect}}, \code{\link{colnames}},
  \code{\link{coltypes}},
  \code{\link{createOrReplaceTempView}},
  \code{\link{crossJoin}}, \code{\link{cube}},
  \code{\link{dapplyCollect}}, \code{\link{dapply}},
  \code{\link{describe}}, \code{\link{dim}},
  \code{\link{distinct}}, \code{\link{dropDuplicates}},
  \code{\link{dropna}}, \code{\link{drop}},
  \code{\link{dtypes}}, \code{\link{exceptAll}},
  \code{\link{except}}, \code{\link{explain}},
  \code{\link{filter}}, \code{\link{first}},
  \code{\link{gapplyCollect}}, \code{\link{gapply}},
  \code{\link{getNumPartitions}}, \code{\link{group_by}},
  \code{\link{head}}, \code{\link{hint}},
  \code{\link{histogram}}, \code{\link{insertInto}},
  \code{\link{intersectAll}}, \code{\link{intersect}},
  \code{\link{isLocal}}, \code{\link{isStreaming}},
  \code{\link{join}}, \code{\link{limit}},
  \code{\link{localCheckpoint}}, \code{\link{merge}},
  \code{\link{mutate}}, \code{\link{ncol}},
  \code{\link{nrow}}, \code{\link{persist}},
  \code{\link{printSchema}}, \code{\link{randomSplit}},
  \code{\link{rbind}}, \code{\link{rename}},
  \code{\link{repartitionByRange}},
  \code{\link{repartition}}, \code{\link{rollup}},
  \code{\link{sample}}, \code{\link{saveAsTable}},
  \code{\link{schema}}, \code{\link{selectExpr}},
  \code{\link{showDF}}, \code{\link{show}},
  \code{\link{storageLevel}}, \code{\link{str}},
  \code{\link{subset}}, \code{\link{summary}},
  \code{\link{take}}, \code{\link{toJSON}},
  \code{\link{unionByName}}, \code{\link{union}},
  \code{\link{unpersist}}, \code{\link{withColumn}},
  \code{\link{withWatermark}}, \code{\link{with}},
  \code{\link{write.df}}, \code{\link{write.jdbc}},
  \code{\link{write.json}}, \code{\link{write.orc}},
  \code{\link{write.parquet}}, \code{\link{write.stream}},
  \code{\link{write.text}}

Other subsetting functions: \code{\link{filter}},
  \code{\link{subset}}
}
\concept{SparkDataFrame functions}
\concept{subsetting functions}
