% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{from_unixtime}
\alias{from_unixtime}
\alias{from_unixtime}
\alias{from_unixtime,Column-method}
\title{from_unixtime}
\usage{
from_unixtime(x, ...)

\S4method{from_unixtime}{Column}(x, format = "yyyy-MM-dd HH:mm:ss")
}
\arguments{
\item{x}{a Column of unix timestamp.}

\item{...}{further arguments to be passed to or from other methods.}

\item{format}{the target format. See
\href{http://docs.oracle.com/javase/tutorial/i18n/format/simpleDateFormat.html}{
Customizing Formats} for available options.}
}
\description{
Converts the number of seconds from unix epoch (1970-01-01 00:00:00 UTC) to a string
representing the timestamp of that moment in the current system time zone in the given
format.
}
\note{
from_unixtime since 1.5.0
}
\examples{
\dontrun{
from_unixtime(df$t)
from_unixtime(df$t, 'yyyy/MM/dd HH')
}
}
\seealso{
Other datetime_funcs: \code{\link{add_months}},
  \code{\link{date_add}}, \code{\link{date_format}},
  \code{\link{date_sub}}, \code{\link{datediff}},
  \code{\link{dayofmonth}}, \code{\link{dayofyear}},
  \code{\link{from_utc_timestamp}}, \code{\link{hour}},
  \code{\link{last_day}}, \code{\link{minute}},
  \code{\link{months_between}}, \code{\link{month}},
  \code{\link{next_day}}, \code{\link{quarter}},
  \code{\link{second}}, \code{\link{to_date}},
  \code{\link{to_utc_timestamp}},
  \code{\link{unix_timestamp}}, \code{\link{weekofyear}},
  \code{\link{window}}, \code{\link{year}}
}
