% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\docType{methods}
\name{doEvent}
\alias{doEvent}
\alias{doEvent,simList,logical-method}
\alias{doEvent,simList,missing-method}
\title{Process a simulation event}
\usage{
doEvent(sim, debug)

\S4method{doEvent}{simList,logical}(sim, debug)

\S4method{doEvent}{simList,missing}(sim)
}
\arguments{
\item{sim}{Character string for the \code{simList} simulation object.}

\item{debug}{Optional logical flag determines whether sim debug info
will be printed (default is \code{debug=FALSE}).}
}
\value{
Returns the modified \code{simList} object.
}
\description{
Internal function called from \code{spades}.
}
\details{
Calls the module corresponding to the event call, and executes the event.

Based on code from chapter 7.8.3 of Matloff (2011): "Discrete event simulation".
Here, we implement a simulation in a more modular fashion so it's easier to add
submodules to the simulation. We use S4 classes and methods, and use `data.table`
instead of `data.frame` to implement the event queue (because it is much faster).
}
\author{
Alex Chubaty
}
\references{
Matloff, N. (2011). The Art of R Programming (ch. 7.8.3). San Fransisco, CA: No Starch Press, Inc.. Retrieved from \url{https://www.nostarch.com/artofr.htm}
}
\keyword{internal}

