% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpaCCRFunctions.R
\name{SpaCC_Path_Parallel}
\alias{SpaCC_Path_Parallel}
\title{Solve Spatial Convex Clustering problem for path of regularization parameters in parallel}
\usage{
SpaCC_Path_Parallel(X, w, gamma.seq, nu = 1/nrow(X), verbose = FALSE,
  tol.base = 1e-04, tol.miss = 1e-04, max.iter.base = 5000,
  max.iter.miss = 500, ncores = 2)
}
\arguments{
\item{X}{A subject (n) by variable (p) matrix; the data}

\item{w}{A vector of length p-1; weights for clustering}

\item{gamma.seq}{A vector of positive scalars; regularization parameter sequence}

\item{nu}{A positive scalar; augmented Lagrangian paramter}

\item{verbose}{Logical; should messages be printed?}

\item{tol.base}{A small positive scalar; convergence tolerance for base SpaCC problem.}

\item{tol.miss}{A small positive scalar; convergence tolerance for missing data problem.}

\item{max.iter.base}{A positive integer; maximum number of iterations for base SpaCC problem}

\item{max.iter.miss}{A positive integer; maximum number of iterations for missing data problem}

\item{ncores}{A positive integer; number of cores to use}
}
\value{
A list with elements UPath, VPath, LamPath, and gamma.seq
}
\description{
Solve Spatial Convex Clustering problem for path of regularization parameters in parallel
}
\examples{
NULL
}

