% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{sourceSankeyDiagram}
\alias{sourceSankeyDiagram}
\title{Create a D3 JavaScript Sankey diagram}
\usage{
sourceSankeyDiagram(
  sourceObj,
  name.graphs = names(sourceObj),
  map.name.variable = NULL,
  cutoff = 50,
  cut.extra.module = TRUE,
  height = NULL,
  width = NULL
)
}
\arguments{
\item{sourceObj}{a \code{SourceSetObj} objects, i.e. the output of the \code{\link[SourceSet]{sourceSet}} function}

\item{name.graphs}{the names of the graphs to be visualized. Default value is \code{names(sourceObj)}}

\item{map.name.variable}{a list of customized labels to be associated with the names of the genes. Each list element must contain only one value (i.e. the new label), and the name of each element must be associated with the names of the genes given as input to the \code{\link[SourceSet]{sourceSet}} function (column names of \code{data} input argument). If a label is not mapped, the original name is used}

\item{cutoff}{the maximum number of variables to include in the sankey graph. The final number of visualized variables could be higher than the \code{cutoff} number}

\item{cut.extra.module}{if set to \code{TRUE}, modules consisting only of variables excluded by the cutoff are not displayed}

\item{height}{numeric height (in pixels) for the network graph's frame area}

\item{width}{numeric width (in pixels) for the network graph's frame area}
}
\value{
The function returns an interactive \code{sankeyNetwork} object.
}
\description{
The function \code{sourceSankeyDiagram} allows to summarize the results obtained from the \code{\link[SourceSet]{sourceSet}} function through a Sankey diagram, highlighting the relationships among nodes, graphs, and source sets.
}
\details{
The layout is organized on three levels:
\itemize{
   \item{ the first level (left) shows nodes that appear in at least one source sets of the analyzed graphs; }
   \item{ the second level (center) is made up of modules. A module is defined as a set of nodes belonging to a connected subgraph of one pathway, that is also contained in associated source set. A pathway can have multiple modules, and, at the same time, one module can be contained in multiple pathways;}
   \item{ the third level (right) shows of pathways. }
 }
 The three levels are to be read from left to right. A link between left element a and right element b must be interpret as "a is contained in b".

 The implementation of the \code{sourceSankeyDiagram} function takes advantage of the D3 library (JavaScript), making the plot interactive.
 In fact, it is possible to vertically shift the displayed elements, and to view some useful information by positioning the cursor over items and links.
}
\examples{
## Load the SourceSetObj obtained from the source set analysis of ALL dataset

# see vignette for more details
print(load(file=system.file("extdata","ALLsourceresult.RData",package = "SourceSet")))
class(results.all)

sourceSankeyDiagram(sourceObj = results.all ,cut.extra.module = FALSE )

# shows the variable that appears most often in the source sets
sourceSankeyDiagram(sourceObj = results.all, cutoff = 1 ,cut.extra.module = FALSE )
# cut modules in which the variable is not contained
sourceSankeyDiagram(sourceObj = results.all, cutoff = 1 ,cut.extra.module = TRUE )
}
\references{
Allaire, J.J., Gandrud, G., Russell, K., and Yetman, C.J. (2017). networkD3: D3 JavaScript Network Graphs from R, r package version 0.4 edition.

Bostock, M., Ogievetsky, V., and Heer, J. (2011). D3 data-driven documents. IEEE Transactions on Visualization and Computer Graphics, 17(12):2301–2309.
}
\seealso{
\code{\link[networkD3]{sankeyNetwork}}, \code{\link[SourceSet]{sourceSet}}, \code{\link[SourceSet]{easyLookSource}}
}
