% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model.R
\name{getDecompOp,Model-method}
\alias{getDecompOp,Model-method}
\title{Extract the Compartmental Operator}
\usage{
\S4method{getDecompOp}{Model}(object)
}
\arguments{
\item{object}{object of class:\code{Model}, A modelrun as produced by the constructors: 
 \code{\link{Model}},
 \code{\link{Model_by_PoolNames}},
 \code{\link{Model_14}}
the function \code{\link{GeneralModel}} or the functions listed in 
\code{\link{predefinedModels}}. \cr
A model represents the initial value problem (IVP)  
for the contents of the pool consisting of 
\itemize{
 \item{ The initial values of the pool content}
 \item{ The system of ordinary differential equations, as dictated by the fluxes}
 \item{ The times for which the solution of the IVP is evaluated.}
}}
}
\value{
The actual class of the result can vary. 
It will be a subclass of \code{\linkS4class{DecompOp}}. 
These objects are an abstraction for a complete description of the fluxes in
the pool system regardless of the form it is provided in.
The information contained in these objects is equivalent to the set of internal and outward fluxes as
functions of pool contents and time and sufficient to infer
the "Compartmental Matrix" as a matrix valued function of the same arguments.
In the general case of a nonautonomous nonlinear Model this function
is a true function of  both, the pool contents and time.
In the case of an non-autonomous linear model it is a function of time only,
and in case of a autonomous linear model it is a constant matrix.
The vector valued function can be inferred by the generic  
function \code{\link{getFunctionDefinition}}.
}
\description{
The method is usually used internally by other methods operating on 
models. The information it yields has either been provided by the user in
creating the modelrun or can be obtained by directly transforming the
arguments that were used.
}
