% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{CN_input_amendments_LUT}
\alias{CN_input_amendments_LUT}
\title{Look-up-table with default values to calculate C and N inputs by organic amendments}
\format{
A tibble with 27 rows and 7 columns:
\describe{
  \item{Amendment}{Name of the amendment}
  \item{DMC}{Dry matter content of the amendment [gDM/kgFM]}
  \item{OM}{Organic matter content of the amendment, relative to its fresh weight [gDM/kgFM]}
  \item{C_content}{Carbon content of the amendment, relative to its dry matter [gC/kgDM]}
  \item{N_tot}{Total N conent of the amendment, relative to it's dry fresh weight [gN/kgFM]}
  \item{N_content}{Nitrogen content of the amendment, relative to its dry matter [gN/kgDM]}
  \item{Comment}{Comment, e.g. source of the information. These lines are shown as part of the function output}
}
}
\usage{
CN_input_amendments_LUT
}
\description{
The dataset is a look-up-table that is used to calculate the carbon (C) and
 nitrogen (N) inputs by organic amendments with the function 
 `SoilManageR::CN_input_amendments()`. The data set is produced from the excel
 table `CN_input_amendments_LUT.xlsx` file under `/inst/extdata/`.
}
\references{
Compilation of Values from the SoilX project.
 Please check the `CN_input_amendments_LUT.xlsx` file under `/inst/extdata/` 
 for more information
 
\insertRef{GRUD2017_ch8}{SoilManageR}

\insertRef{GRUD2017_ch4}{SoilManageR}
}
\keyword{datasets}
