% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PopulateUserInfo.R
\name{PopulateUserInfo}
\alias{PopulateUserInfo}
\title{Populate Twitter networks with user information}
\usage{
PopulateUserInfo(networkObject)
}
\arguments{
\item{networkObject}{an igraph graph object created with \code{\link{Create}}}
}
\value{
An igraph graph object
}
\description{
This function is used to 'populate' Twitter networks (generated
with the \code{\link{Create}} function) with information about
the users in the network. This involves calls to the Twitter API
to collect this information, which is then applied to the network
as vertex attributes.
}
\examples{

\dontrun{
require(magrittr)
## Get Twitter user information and apply to network
myTwitterNetwork_userInfo <- PopulateUserInfo(myTwitterNetwork)

}
}
\author{
Timothy Graham <timothy.graham3@uq.net.au> & Robert Ackland
<robert.ackland@anu.edu.au>
}
\seealso{
\code{\link{Collect}}, \code{\link{Create}}
}

