% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stripExtension.R
\name{stripExtension}
\alias{stripExtension}
\title{Remove the extension of a vector of filenames}
\usage{
stripExtension(vec, split.char = ".")
}
\arguments{
\item{vec}{Character vector (usually containing filenames)}

\item{split.char}{A single character used to split the character strings}
}
\value{
Character vector with the last "." and the
filename extension removed.  Alternatively, another split character could
be used.
}
\description{
Remove the extension of a vector of filenames, assuming that the extension is the set of characters
that follows the last \code{"."}
}
\details{
Assumes paths are delineated using forward slashes.  If an \code{NA} is
supplied, then an \code{NA} is returned.  If the desired string doesn't
exist (see examples below), a \code{""} is returned.
}
\examples{
stripExtension(c("this old file.doc", "that young file.rtf",
                 "this.good.file.doc", "this_bad_file"))

stripExtension(c("this old file*doc", "that young file*rtf",
                 "this*good*file*doc", "this_bad_file"), split.char = "*")


# Named vectors are not required, but are included here to make the
# output easier to read.  This example demonstrates a number of
# pathological cases.
stripExtension(c(a = NA, b = ".doc", c = "this.pdf", d = "this.file.", e = ".",
                 f = "noExtension", g = "direc.name/filename.txt", h = ""))

# An example with 'real' files
files <- dir(file.path(path.package(package = "Smisc"), "data"), full.names = TRUE)
print(files)
stripExtension(files)
stripExtension(stripPath(files))
}
\author{
Landon Sego
}
\seealso{
Additional functions for filename manipulations:  \code{\link{getExtension}}, \code{\link{stripPath}},
\code{\link{getPath}}, \code{\link{grabLast}}, \code{\link{basename}}, \code{\link{dirname}}
}
\keyword{misc}

